/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import java.io.IOException;
import java.net.URL;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.openbase.bco.bcozy.controller.CenterPaneController;
import org.openbase.bco.bcozy.controller.SettingsController;
import org.openbase.bco.bcozy.controller.UserSettingsController;
import org.openbase.bco.bcozy.view.FloatingPopUp;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenterPane
extends StackPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(CenterPane.class);
    private UserSettingsController userSettingsController;
    private Pane settingsMenu;
    private final ForegroundPane foregroundPane;
    public final ObjectProperty<CenterPaneController.State> appStateProperty;

    public CenterPane(double height, ForegroundPane foregroundPane) {
        this.foregroundPane = foregroundPane;
        this.appStateProperty = new SimpleObjectProperty((Object)CenterPaneController.State.MOVEMENT);
        this.settingsMenu = this.loadSettingsMenu(height);
        FloatingPopUp viewModes = new FloatingPopUp(Pos.BOTTOM_RIGHT);
        viewModes.addParentElement((GlyphIcons)MaterialIcon.WEEKEND, () -> this.appStateProperty.set((Object)CenterPaneController.State.MOVEMENT));
        viewModes.addElement((GlyphIcons)MaterialDesignIcon.THERMOMETER_LINES, () -> this.appStateProperty.set((Object)CenterPaneController.State.TEMPERATURE));
        viewModes.addElement((GlyphIcons)MaterialIcon.VISIBILITY, () -> this.appStateProperty.set((Object)CenterPaneController.State.SETTINGS));
        this.getStyleClass().addAll((Object[])new String[]{"padding-small"});
        this.setPickOnBounds(false);
        this.getChildren().addAll((Object[])new Node[]{viewModes});
        this.setMinHeight(height);
        this.setPrefHeight(height);
    }

    private Pane loadSettingsMenu(double height) {
        try {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("SettingsMenu.fxml");
            if (url == null) {
                throw new NotAvailableException("SettingsMenu.fxml");
            }
            FXMLLoader loader = new FXMLLoader(url);
            loader.setControllerFactory(clazz -> new SettingsController(this.foregroundPane));
            AnchorPane anchorPane = (AnchorPane)loader.load();
            SettingsController settingsController = (SettingsController)loader.getController();
            this.userSettingsController = settingsController.getUserSettingsController();
            this.setMinHeight(height);
            this.setPrefHeight(height);
            anchorPane.getStyleClass().addAll((Object[])new String[]{"detail-menu"});
            anchorPane.setMinHeight(height);
            anchorPane.setPrefHeight(height);
            return anchorPane;
        }
        catch (IOException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Content could not be loaded", (Throwable)ex, (Logger)LOGGER);
            return new Pane(new Node[]{new ObserverLabel("unavailable")});
        }
    }

    public UserSettingsController getSettingsPane() {
        return this.userSettingsController;
    }

    public Pane getSettingsMenu() {
        return this.settingsMenu;
    }
}

