/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.GlyphIcons;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.view.FloatingButton;
import org.openbase.bco.bcozy.view.SVGIcon;

public class FloatingPopUp
extends VBox {
    private FloatingButton popUpParent;
    private final VBox viewSwitcherPopUp;
    private boolean visible = false;
    private final Map<GlyphIcons, EventHandler<ActionEvent>> eventHandler = new HashMap<GlyphIcons, EventHandler<ActionEvent>>();
    private GlyphIcons parent;

    public FloatingPopUp(Pos position) {
        super(10.0);
        this.setMaxSize(48.0, Double.MAX_VALUE);
        this.setAlignment(position);
        this.viewSwitcherPopUp = new VBox(10.0);
        this.viewSwitcherPopUp.setAlignment(Pos.CENTER);
        StackPane.setAlignment((Node)this, (Pos)position);
        this.translateYProperty().set(-10.0);
    }

    public final void addParentElement(GlyphIcons icon, Runnable handler) {
        this.addParentElement(icon, (EventHandler<ActionEvent>)((EventHandler)event -> handler.run()));
    }

    public final void addParentElement(GlyphIcons icon, EventHandler<ActionEvent> value) {
        this.parent = icon;
        this.eventHandler.put(icon, value);
        this.showParent();
        this.addChildren();
        this.setViewSwitchingButtonsVisible(this.visible);
    }

    public final void addElement(GlyphIcons icon, Runnable handler) {
        this.addElement(icon, (EventHandler<ActionEvent>)((EventHandler)event -> handler.run()));
    }

    public final void addElement(GlyphIcons icon, EventHandler<ActionEvent> value) {
        this.eventHandler.put(icon, value);
        this.addChildren();
    }

    public void clickOnChild(GlyphIcons clicked) {
        this.parent = clicked;
        this.showParent();
        this.addChildren();
        this.switchingButtonsVisible();
    }

    private void addChildren() {
        this.viewSwitcherPopUp.getChildren().clear();
        for (Map.Entry<GlyphIcons, EventHandler<ActionEvent>> glyphIconsEventHandlerEntry : this.eventHandler.entrySet()) {
            GlyphIcons icon = glyphIconsEventHandlerEntry.getKey();
            EventHandler<ActionEvent> handler = glyphIconsEventHandlerEntry.getValue();
            if (icon == this.parent) continue;
            FloatingButton element = new FloatingButton(new SVGIcon(icon, 32.0, true));
            this.viewSwitcherPopUp.getChildren().addAll((Object[])new Node[]{element});
            element.setOnAction(event -> {
                this.clickOnChild(icon);
                if (Objects.nonNull(handler)) {
                    handler.handle(event);
                }
            });
        }
    }

    private void showParent() {
        this.popUpParent = new FloatingButton(new SVGIcon(this.parent, 48.0, true));
        this.popUpParent.setOnAction(event -> this.switchingButtonsVisible());
    }

    public void switchingButtonsVisible() {
        this.visible = !this.visible;
        this.setViewSwitchingButtonsVisible(this.visible);
    }

    private void setViewSwitchingButtonsVisible(boolean visible) {
        if (visible) {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.popUpParent, this.viewSwitcherPopUp});
        } else {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.popUpParent});
        }
    }
}

