/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import java.util.Observable;
import java.util.Observer;
import java.util.function.Function;
import javafx.beans.DefaultProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import org.openbase.bco.bcozy.model.LanguageSelection;

@DefaultProperty(value="identifier")
public class ObserverButton
extends Button
implements Observer {
    @FXML
    private SimpleStringProperty identifier = new SimpleStringProperty();
    private Function<String, String> applyOnNewText = Function.identity();

    public ObserverButton() {
        this.identifier.addListener((observable, oldValue, newValue) -> this.update(null, null));
        LanguageSelection.getInstance().addObserver(this);
    }

    public ObserverButton(String languageString) {
        this();
        this.setIdentifier(languageString);
    }

    public ObserverButton(String languageString, Node graphic) {
        this(languageString);
        super.setGraphic(graphic);
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (this.getIdentifier() == null || this.getIdentifier().isEmpty()) {
            return;
        }
        String text = LanguageSelection.getLocalized(this.getIdentifier());
        super.setText(this.applyOnNewText.apply(text));
    }

    public String getIdentifier() {
        return this.identifier.get();
    }

    public StringProperty identifierProperty() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier.set(identifier != null ? identifier.trim() : null);
    }

    public void setApplyOnNewText(Function<String, String> applyOnNewText) {
        this.applyOnNewText = applyOnNewText != null ? applyOnNewText : Function.identity();
        this.update(null, null);
    }
}

