/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import java.util.Observable;
import java.util.Observer;
import java.util.function.Function;
import javafx.beans.DefaultProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="identifier")
public class ObserverText
extends Text
implements Observer {
    protected final Logger LOGGER = LoggerFactory.getLogger(ObserverText.class);
    @FXML
    private SimpleStringProperty identifier = new SimpleStringProperty();
    private Function<String, String> applyOnNewText = Function.identity();

    public ObserverText() {
        this.identifier.addListener((observable, oldValue, newValue) -> this.update(null, null));
        LanguageSelection.getInstance().addObserver(this);
    }

    public ObserverText(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    @Override
    public void update(Observable observable, Object arg) {
        this.update();
    }

    public void update() {
        if (this.getIdentifier() == null) {
            return;
        }
        String text = LanguageSelection.getLocalized(this.getIdentifier());
        super.setText(this.applyOnNewText.apply(text));
    }

    public void setIdentifier(String identifier) {
        this.identifier.set(identifier);
    }

    public String getIdentifier() {
        return this.identifier.get();
    }

    public SimpleStringProperty identifierProperty() {
        return this.identifier;
    }

    public void setApplyOnNewText(Function<String, String> applyOnNewText) {
        this.applyOnNewText = applyOnNewText != null ? applyOnNewText : Function.identity();
        this.update();
    }
}

