/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.Future;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.LightRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.LightDataType;

public class LightPane
extends AbstractUnitPane<LightRemote, LightDataType.LightData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPane.class);

    public LightPane() {
        super(LightRemote.class, true);
        this.setIcon((GlyphIcons)MaterialDesignIcon.LIGHTBULB_OUTLINE, (GlyphIcons)MaterialDesignIcon.LIGHTBULB);
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        PowerStateType.PowerState.State state = PowerStateType.PowerState.State.UNKNOWN;
        try {
            state = ((LightDataType.LightData)((LightRemote)this.getUnitRemote()).getData()).getPowerState().getValue();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        switch (state) {
            case OFF: {
                this.getIcon().setBackgroundIconColor(Constants.LIGHTBULB_OFF_COLOR);
                this.setInfoText("lightOff");
                this.setPrimaryActivationWithoutNotification(Boolean.FALSE);
                break;
            }
            case ON: {
                this.getIcon().setBackgroundIconColor(Color.CORNSILK);
                this.setInfoText("lightOn");
                this.setPrimaryActivationWithoutNotification(Boolean.TRUE);
                break;
            }
            default: {
                this.setInfoText("unknown");
            }
        }
    }

    @Override
    protected Future applyPrimaryActivationUpdate(boolean activation) throws CouldNotPerformException {
        return activation ? ((LightRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.ON) : ((LightRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.OFF);
    }
}

