/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.view.mainmenupanes.ObserverTitledPane;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.bcozy.view.pane.unit.UnitPaneFactoryImpl;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class UnitPaneContainer
extends ObserverTitledPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitPaneContainer.class);
    private final VBox vBox = new VBox();

    public UnitPaneContainer(String unitTypeName) {
        super(unitTypeName);
        this.vBox.getStyleClass().add((Object)"observer-titled-pane");
        this.getStyleClass().add((Object)"observer-titled-pane");
        this.setContent((Node)this.vBox);
    }

    public void createAndAddNewUnitPanes(UnitTemplateType.UnitTemplate.UnitType unitType, List<UnitRemote> dalRemoteServiceList) throws InterruptedException {
        this.setExpanded(false);
        for (UnitRemote remote : dalRemoteServiceList) {
            try {
                this.vBox.getChildren().add((Object)UnitPaneFactoryImpl.getInstance().newInitializedInstance((UnitConfigType.UnitConfig)remote.getConfig()));
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)("UnitType[" + unitType + "] is not supported yet!"), (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.WARN);
            }
        }
    }

    public void clearUnitPaneContainer() {
        for (Node node : this.vBox.getChildren()) {
            ((AbstractUnitPane)node).shutdown();
        }
        this.getChildren().clear();
    }

    public int size() {
        return this.vBox.getChildren().size();
    }

    public boolean isEmpty() {
        return this.vBox.getChildren().isEmpty();
    }
}

