/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import org.openbase.bco.bcozy.util.AuthorizationGroups;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.authentication.PermissionConfigType;
import rst.domotic.authentication.PermissionType;
import rst.domotic.unit.UnitConfigType;

public class PermissionPaneController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionPaneController.class);
    @FXML
    private TableColumn<PermissionConfigType.PermissionConfig.MapFieldEntry, String> usergroupColumn;
    @FXML
    private TableColumn<PermissionConfigType.PermissionConfig.MapFieldEntry, String> permissionsColumn;
    @FXML
    private TableView<PermissionConfigType.PermissionConfig.MapFieldEntry> permissionsTable;
    @FXML
    public ChoiceBox<UnitConfigType.UnitConfig> newGroupChoiceBox;
    @FXML
    public CheckBox readRights;
    @FXML
    public CheckBox writeRights;
    @FXML
    public CheckBox accessRights;
    @FXML
    public ObserverButton saveRightsButton;
    @FXML
    public HBox hbox;
    private UnitConfigType.UnitConfig unitConfig;
    private ObservableList<UnitConfigType.UnitConfig> groups = AuthorizationGroups.getAuthorizationGroups();

    @FXML
    public void initialize() {
        this.onWidthChange(null, null, null);
        this.permissionsTable.widthProperty().addListener(this::onWidthChange);
        this.usergroupColumn.setGraphic((Node)new ObserverLabel("usergroups"));
        this.permissionsColumn.setGraphic((Node)new ObserverLabel("permissions"));
        this.usergroupColumn.widthProperty().addListener(this::onColumnWidthChange);
        this.readRights.setGraphic((Node)new ObserverLabel("readRight"));
        this.writeRights.setGraphic((Node)new ObserverLabel("writeRight"));
        this.accessRights.setGraphic((Node)new ObserverLabel("accessRight"));
        this.saveRightsButton.getStyleClass().clear();
        this.saveRightsButton.getStyleClass().addAll((Object[])new String[]{"transparent-button"});
        this.saveRightsButton.setApplyOnNewText(String::toUpperCase);
        this.newGroupChoiceBox.setConverter(AuthorizationGroups.stringConverter(this.groups));
        this.newGroupChoiceBox.setItems(this.groups);
        this.newGroupChoiceBox.setPrefWidth(-1.0);
        this.preselectGroupChoiceBoxValue();
        this.groups.addListener(c -> this.preselectGroupChoiceBoxValue());
        this.usergroupColumn.setCellValueFactory(param -> {
            for (UnitConfigType.UnitConfig group : this.groups) {
                if (!((PermissionConfigType.PermissionConfig.MapFieldEntry)param.getValue()).getGroupId().equals(group.getId())) continue;
                return new SimpleStringProperty(group.getLabel());
            }
            return null;
        });
        this.permissionsColumn.setCellValueFactory(param -> new SimpleStringProperty((((PermissionConfigType.PermissionConfig.MapFieldEntry)param.getValue()).getPermission().getAccess() ? "A" : "a") + "," + (((PermissionConfigType.PermissionConfig.MapFieldEntry)param.getValue()).getPermission().getRead() ? "R" : "r") + "," + (((PermissionConfigType.PermissionConfig.MapFieldEntry)param.getValue()).getPermission().getWrite() ? "W" : "w") + ","));
    }

    private void preselectGroupChoiceBoxValue() {
        if (!this.groups.isEmpty() && this.newGroupChoiceBox.getValue() == null) {
            this.newGroupChoiceBox.setValue(this.groups.get(0));
        }
    }

    public void updateTableContent() {
        this.permissionsTable.setItems(FXCollections.observableArrayList());
        for (PermissionConfigType.PermissionConfig.MapFieldEntry group : this.unitConfig.getPermissionConfig().getGroupPermissionList()) {
            this.permissionsTable.getItems().add((Object)group);
        }
    }

    private void onWidthChange(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        double width = this.permissionsTable.getWidth();
        this.hbox.setPrefWidth(width);
        this.hbox.setSpacing(10.0);
        this.saveRightsButton.setLayoutX(width - 100.0);
        this.newGroupChoiceBox.setPrefWidth(width / 5.0);
        this.readRights.setPrefWidth(width / 5.0);
        this.writeRights.setPrefWidth(width / 5.0);
        this.accessRights.setPrefWidth(width / 5.0);
        this.usergroupColumn.setPrefWidth(width / 2.0);
        this.permissionsColumn.setPrefWidth(width / 2.0);
    }

    private void onColumnWidthChange(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        double width = this.permissionsTable.getWidth();
        this.permissionsColumn.setPrefWidth(width - newValue.doubleValue());
    }

    public void setUnitConfig(UnitConfigType.UnitConfig unitConfig) {
        this.unitConfig = unitConfig;
        this.updateTableContent();
    }

    @FXML
    public void save(ActionEvent actionEvent) {
        String groupId = "43573651-0c9b-4765-b61b-b20ba31df53e";
        if (this.newGroupChoiceBox.getSelectionModel() != null && this.newGroupChoiceBox.getSelectionModel().getSelectedItem() != null) {
            groupId = ((UnitConfigType.UnitConfig)this.newGroupChoiceBox.getSelectionModel().getSelectedItem()).getId();
        }
        PermissionConfigType.PermissionConfig.MapFieldEntry mapFieldEntry = PermissionConfigType.PermissionConfig.MapFieldEntry.newBuilder().setGroupId(groupId).setPermission(PermissionType.Permission.newBuilder().setAccess(this.accessRights.isSelected()).setWrite(this.writeRights.isSelected()).setRead(this.readRights.isSelected()).build()).build();
        ArrayList<PermissionConfigType.PermissionConfig.MapFieldEntry> entryListCopy = new ArrayList<PermissionConfigType.PermissionConfig.MapFieldEntry>(this.unitConfig.getPermissionConfig().getGroupPermissionList());
        entryListCopy.removeIf(entry -> mapFieldEntry.getGroupId().equals(entry.getGroupId()));
        PermissionConfigType.PermissionConfig permissionConfig = this.unitConfig.getPermissionConfig().toBuilder().clearGroupPermission().addAllGroupPermission(entryListCopy).addGroupPermission(mapFieldEntry).build();
        UnitConfigType.UnitConfig unitConfig = this.unitConfig.toBuilder().clearPermissionConfig().mergePermissionConfig(permissionConfig).build();
        try {
            unitConfig = (UnitConfigType.UnitConfig)Registries.getUnitRegistry().updateUnitConfig(unitConfig).get();
            this.setUnitConfig(unitConfig);
        }
        catch (ExecutionException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

