/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.JFXTreeTableView;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.textfield.CustomTextField;
import org.openbase.bco.bcozy.BCozy;
import org.openbase.bco.bcozy.controller.MainMenuController;
import org.openbase.bco.bcozy.controller.PermissionPaneController;
import org.openbase.bco.bcozy.controller.RegistrationController;
import org.openbase.bco.bcozy.controller.UserSettingsController;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class SettingsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainMenuController.class);
    public Accordion adminAccordion;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab settingsTab;
    @FXML
    private Tab permissionTab;
    @FXML
    private JFXTreeTableView<RecursiveUnitConfig> unitsTable;
    @FXML
    private CustomTextField filterInput;
    @FXML
    private VBox permissionPaneParent;
    private Pane permissionPane;
    private UserSettingsController userSettingsController;
    private PermissionPaneController permissionPaneController;
    private JFXTreeTableColumn<RecursiveUnitConfig, String> typeColumn;
    final ObservableList<RecursiveUnitConfig> list = FXCollections.observableArrayList();
    private final ForegroundPane foregroudPane;

    public SettingsController(ForegroundPane foregroudPane) {
        this.foregroudPane = foregroudPane;
    }

    @FXML
    public void initialize() {
        this.settingsTab.setGraphic((Node)new ObserverLabel("settings"));
        this.permissionTab.setGraphic((Node)new ObserverLabel("permissions"));
        this.fillTreeTableView();
        Pane userSettingsPane = this.loadUserSettingsPane();
        this.settingsTab.setContent((Node)userSettingsPane);
        this.permissionPane = this.loadPermissionPane();
        this.permissionPane.setVisible(false);
        this.permissionPaneParent.getChildren().addAll((Object[])new Node[]{this.permissionPane});
        this.tabPane.widthProperty().addListener(this::onPaneWidthChange);
        this.onPaneWidthChange(null, null, null);
        this.tabPane.getStyleClass().addAll((Object[])new String[]{"detail-menu"});
        TitledPane registrationPane = new TitledPane("registration", (Node)this.loadRegistrationPane());
        LanguageSelection.addObserverFor("registration", arg_0 -> ((TitledPane)registrationPane).setText(arg_0));
        this.adminAccordion.getPanes().add((Object)registrationPane);
        TitledPane groupsPane = new TitledPane("usergroups", (Node)this.loadGroupsPane());
        LanguageSelection.addObserverFor("usergroups", arg_0 -> ((TitledPane)groupsPane).setText(arg_0));
        this.adminAccordion.getPanes().add((Object)groupsPane);
        try {
            Registries.getUnitRegistry().addDataObserver((observable, unitRegistryData) -> {
                List unitConfigList = Registries.getUnitRegistry().getUnitConfigs();
                Platform.runLater(() -> this.fillTable(unitConfigList));
            });
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    URL getFxmlURL(String filename) throws NullPointerException {
        return Objects.requireNonNull(this.getClass().getClassLoader().getResource(filename), filename + " not found");
    }

    private Pane loadUserSettingsPane() {
        try {
            URL url = this.getFxmlURL("UserSettingsPane.fxml");
            FXMLLoader loader = new FXMLLoader(url);
            loader.setControllerFactory(clazz -> new UserSettingsController(this.foregroudPane));
            Pane root = (Pane)loader.load();
            this.userSettingsController = (UserSettingsController)loader.getController();
            this.userSettingsController.initialize();
            this.userSettingsController.getThemeChoice().setOnAction(event -> this.chooseTheme());
            this.userSettingsController.getThemeChoice().getSelectionModel().select(0);
            return root;
        }
        catch (IOException ex) {
            ExceptionPrinter.printHistory((String)"Content could not be loaded", (Throwable)ex, (Logger)LOGGER);
            throw new UncheckedIOException(ex);
        }
    }

    private <T> void onPaneWidthChange(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        double width = this.tabPane.getWidth();
        double childrenCount = this.settingsTab.getTabPane().getTabs().size();
        this.settingsTab.getTabPane().setTabMinWidth(width / (childrenCount + 1.0));
    }

    public void fillTreeTableView() {
        this.unitsTable.setShowRoot(false);
        this.unitsTable.setEditable(true);
        JFXTreeTableColumn<RecursiveUnitConfig, String> labelColumn = this.createJFXTreeTableColumn("Units", unit -> unit.getUnit().getLabel());
        labelColumn.setPrefWidth(150.0);
        JFXTreeTableColumn<RecursiveUnitConfig, String> descColumn = this.createJFXTreeTableColumn("Description", unit -> unit.getUnit().getDescription());
        descColumn.setPrefWidth(150.0);
        this.typeColumn = this.createJFXTreeTableColumn("Type", unit -> unit.getUnit().getType().name());
        this.typeColumn.setPrefWidth(150.0);
        this.unitsTable.getColumns().addAll((Object[])new TreeTableColumn[]{this.typeColumn, labelColumn, descColumn});
        RecursiveTreeItem item = new RecursiveTreeItem(this.list, RecursiveTreeObject::getChildren);
        this.unitsTable.setRoot((TreeItem)item);
        this.unitsTable.getSelectionModel().selectedItemProperty().addListener(this::onSelectionChange);
        this.filterInput.setRight((Node)new SVGIcon((GlyphIcons)FontAwesomeIcon.SEARCH, 16.0, true));
        this.filterInput.promptTextProperty().setValue(new ObserverLabel("searchPlaceholder").getText());
        this.filterInput.textProperty().addListener((o, oldVal, newVal) -> this.unitsTable.setPredicate(user -> ((RecursiveUnitConfig)((Object)((Object)((Object)user.getValue())))).getUnit().getLabel().toLowerCase().contains(newVal.toLowerCase()) || ((RecursiveUnitConfig)((Object)((Object)((Object)user.getValue())))).getUnit().getDescription().toLowerCase().contains(newVal.toLowerCase()) || ((RecursiveUnitConfig)((Object)((Object)((Object)user.getValue())))).getUnit().getType().name().toLowerCase().contains(newVal.toLowerCase())));
    }

    private void onSelectionChange(Observable observable, TreeItem oldValue, TreeItem newValue) {
        if (Objects.nonNull(newValue) && newValue.getValue() instanceof RecursiveUnitConfig) {
            this.setPermissionPaneVisible(true);
            this.permissionPaneController.setUnitConfig(((RecursiveUnitConfig)((Object)newValue.getValue())).getUnit());
        } else {
            this.setPermissionPaneVisible(false);
        }
    }

    private void setPermissionPaneVisible(boolean visible) {
        this.permissionPane.setVisible(visible);
    }

    private void fillTable(List<UnitConfigType.UnitConfig> unitConfigList) {
        this.unitsTable.unGroup(new TreeTableColumn[]{this.typeColumn});
        this.list.clear();
        for (UnitConfigType.UnitConfig unitConfig : unitConfigList) {
            if (!Objects.nonNull(unitConfig)) continue;
            this.list.add((Object)new RecursiveUnitConfig(unitConfig));
        }
        if (!this.list.isEmpty()) {
            this.unitsTable.group(new TreeTableColumn[]{this.typeColumn});
        }
    }

    private <S, T> JFXTreeTableColumn<S, T> createJFXTreeTableColumn(String text, Function<S, T> supplier) {
        JFXTreeTableColumn column = new JFXTreeTableColumn(text);
        column.setCellValueFactory(new MethodRefCellValueFactory<S, T>(supplier, column));
        return column;
    }

    public UserSettingsController getUserSettingsController() {
        return this.userSettingsController;
    }

    private void chooseTheme() {
        final ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        this.userSettingsController.getThemeChoice().getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (((String)SettingsController.this.userSettingsController.getAvailableThemes().get(number2.intValue())).equals(languageBundle.getString("light"))) {
                    BCozy.changeTheme("/css/light.css");
                } else if (((String)SettingsController.this.userSettingsController.getAvailableThemes().get(number2.intValue())).equals(languageBundle.getString("dark"))) {
                    BCozy.changeTheme("/css/dark.css");
                }
            }
        });
    }

    private AnchorPane loadPermissionPane() {
        try {
            URL url = this.getFxmlURL("PermissionPane.fxml");
            FXMLLoader loader = new FXMLLoader(url);
            AnchorPane anchorPane = (AnchorPane)loader.load();
            this.permissionPaneController = (PermissionPaneController)loader.getController();
            anchorPane.getStyleClass().addAll((Object[])new String[]{"detail-menu"});
            return anchorPane;
        }
        catch (IOException ex) {
            ExceptionPrinter.printHistory((String)"Content could not be loaded", (Throwable)ex, (Logger)LOGGER);
            throw new UncheckedIOException(ex);
        }
    }

    private Pane loadGroupsPane() {
        try {
            URL url = this.getFxmlURL("GroupsPane.fxml");
            FXMLLoader loader = new FXMLLoader(url);
            Pane anchorPane = (Pane)loader.load();
            return anchorPane;
        }
        catch (IOException ex) {
            ExceptionPrinter.printHistory((String)"Content could not be loaded", (Throwable)ex, (Logger)LOGGER);
            throw new UncheckedIOException(ex);
        }
    }

    private Pane loadRegistrationPane() {
        try {
            URL url = Objects.requireNonNull(this.getClass().getClassLoader().getResource("Registration.fxml"), "Registration.fxml not found");
            FXMLLoader loader = new FXMLLoader(url);
            loader.setControllerFactory(clazz -> new RegistrationController());
            Pane root = (Pane)loader.load();
            return root;
        }
        catch (IOException ex) {
            ExceptionPrinter.printHistory((String)"Content could not be loaded", (Throwable)ex, (Logger)LOGGER);
            throw new UncheckedIOException(ex);
        }
    }

    private class MethodRefCellValueFactory<S, T>
    implements Callback<TreeTableColumn.CellDataFeatures<S, T>, ObservableValue<T>> {
        Function<S, T> supplier;
        JFXTreeTableColumn<S, T> column;

        public MethodRefCellValueFactory(Function<S, T> supplier, JFXTreeTableColumn<S, T> column) {
            this.supplier = Objects.requireNonNull(supplier);
            this.column = Objects.requireNonNull(column);
        }

        public ObservableValue<T> call(TreeTableColumn.CellDataFeatures<S, T> param) {
            if (this.column.validateValue(param)) {
                return new SimpleObjectProperty(this.supplier.apply(param.getValue().getValue()));
            }
            return this.column.getComputedValue(param);
        }
    }

    public class RecursiveUnitConfig
    extends RecursiveTreeObject<RecursiveUnitConfig> {
        private final SimpleObjectProperty<UnitConfigType.UnitConfig> unit = new SimpleObjectProperty();

        public RecursiveUnitConfig(UnitConfigType.UnitConfig unitConfig) {
            this.setUnit(unitConfig);
        }

        public UnitConfigType.UnitConfig getUnit() {
            return (UnitConfigType.UnitConfig)this.unit.get();
        }

        public void setUnit(UnitConfigType.UnitConfig unitConfig) {
            this.unit.set((Object)Objects.requireNonNull(unitConfig));
        }

        public SimpleObjectProperty unitProperty() {
            return this.unit;
        }
    }
}

