/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.layout.Pane;
import org.openbase.bco.bcozy.view.location.UnitButton;
import org.openbase.bco.bcozy.view.location.UnitButtonGrouped;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class UnitSymbolsPane
extends Pane {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitSymbolsPane.class);
    private final Map<String, UnitButton> locationUnitsMap = new HashMap<String, UnitButton>();
    private final Map<String, Map<String, UnitButton>> unitsPerLocationMap = new HashMap<String, Map<String, UnitButton>>();
    private final Map<Point2D, UnitButtonGrouped> groupedButtons = new HashMap<Point2D, UnitButtonGrouped>();
    private boolean putIntoGroup;
    public final SimpleStringProperty selectedLocationId = new SimpleStringProperty("DUMMY");

    public UnitSymbolsPane() {
        this.selectedLocationId.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                UnitSymbolsPane.this.updateUnitsPane();
            }
        });
    }

    public void addRoomUnit(UnitRemote<? extends GeneratedMessage> unitRemoteObject, Point2D position) throws CouldNotPerformException, InterruptedException {
        try {
            UnitButton newButton = new UnitButton(unitRemoteObject);
            newButton.setTranslateX(position.getY());
            newButton.setTranslateY(position.getX());
            this.locationUnitsMap.put(((UnitConfigType.UnitConfig)unitRemoteObject.getConfig()).getId(), newButton);
        }
        catch (NotAvailableException ex) {
            throw new CouldNotPerformException("Could not create unit button for unit " + (Object)((Object)this), (Throwable)ex);
        }
    }

    public void addUnit(UnitRemote<? extends GeneratedMessage> unitRemoteObject, Point2D position, String locationId) throws CouldNotPerformException, InterruptedException {
        try {
            UnitButton newButton = new UnitButton(unitRemoteObject);
            newButton.setTranslateX(position.getY());
            newButton.setTranslateY(position.getX());
            this.putIntoGroup = false;
            if (this.unitsPerLocationMap.containsKey(locationId)) {
                Point2D coord = new Point2D(position.getX(), position.getY());
                if (this.groupedButtons.containsKey(coord)) {
                    this.groupedButtons.get(coord).addUnit(unitRemoteObject);
                    this.putIntoGroup = true;
                } else {
                    Iterator<Map.Entry<String, UnitButton>> iter = this.unitsPerLocationMap.get(locationId).entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<String, UnitButton> entry = iter.next();
                        UnitButton button = entry.getValue();
                        if (button.getTranslateX() != position.getY() || button.getTranslateY() != position.getX()) continue;
                        UnitButtonGrouped newGroupedButton = new UnitButtonGrouped();
                        newGroupedButton.setTranslateX(position.getY());
                        newGroupedButton.setTranslateY(position.getX());
                        this.groupedButtons.put(new Point2D(position.getX(), position.getY()), newGroupedButton);
                        newGroupedButton.addUnit(unitRemoteObject);
                        newGroupedButton.addUnit(button.getUnitRemote());
                        iter.remove();
                        this.putIntoGroup = true;
                    }
                }
                if (!this.putIntoGroup) {
                    this.unitsPerLocationMap.get(locationId).put(((UnitConfigType.UnitConfig)unitRemoteObject.getConfig()).getId(), newButton);
                }
            } else {
                HashMap<String, UnitButton> units = new HashMap<String, UnitButton>();
                units.put(((UnitConfigType.UnitConfig)unitRemoteObject.getConfig()).getId(), newButton);
                this.unitsPerLocationMap.put(locationId, units);
            }
        }
        catch (NotAvailableException ex) {
            throw new CouldNotPerformException("Could not create unit button for unit " + (Object)((Object)this), (Throwable)ex);
        }
    }

    public void clearUnits() {
        this.locationUnitsMap.forEach((unitId, button) -> this.getChildren().remove((Object)button));
        this.locationUnitsMap.clear();
        this.unitsPerLocationMap.forEach((locationId, entry) -> entry.forEach((unitId, button) -> this.getChildren().remove((Object)button)));
        this.unitsPerLocationMap.clear();
        this.groupedButtons.forEach((point, button) -> this.getChildren().remove((Object)button));
        this.groupedButtons.clear();
    }

    public void updateUnitsPane() {
        this.getChildren().clear();
        this.locationUnitsMap.forEach((unitId, button) -> {
            if (!unitId.equals(this.selectedLocationId.getValue())) {
                this.getChildren().add((Object)button);
            }
        });
        if (this.unitsPerLocationMap.get(this.selectedLocationId.getValue()) != null) {
            this.unitsPerLocationMap.get(this.selectedLocationId.getValue()).forEach((unitId, button) -> this.getChildren().add((Object)button));
        }
        this.groupedButtons.forEach((point, button) -> {
            if (button.getLocationId() == null) {
                return;
            }
            if (button.getLocationId().equals(this.selectedLocationId.getValue())) {
                this.getChildren().add((Object)button);
            }
        });
    }
}

