/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.permissions.view;

import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import org.openbase.bco.bcozy.permissions.model.AbstractPermissions;
import org.openbase.bco.bcozy.permissions.model.OwnerPermissions;

public class PermissionTableCell<T>
extends TableCell<AbstractPermissions, T> {
    private final ComboBox<OwnerPermissions.Owner> comboBox = new ComboBox();
    private OwnerPermissions model;

    PermissionTableCell() {
        this.comboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.model != null) {
                this.model.owner = newValue;
            }
        });
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            AbstractPermissions permissionsRow = (AbstractPermissions)this.getTableView().getItems().get(this.getIndex());
            if (permissionsRow instanceof OwnerPermissions) {
                this.updateItem((OwnerPermissions)permissionsRow);
            } else {
                this.setGraphic(null);
                this.setText(permissionsRow.getName());
            }
        }
    }

    private void updateItem(OwnerPermissions ownerPermissions) {
        this.model = ownerPermissions;
        this.comboBox.getItems().setAll(this.model.owners);
        this.comboBox.getSelectionModel().select((Object)this.model.owner);
        this.setText(null);
        this.setGraphic((Node)this.comboBox);
    }
}

