/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.layout.Pane;
import org.openbase.bco.bcozy.view.location.UnitButton;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class SimpleUnitSymbolsPane
extends Pane {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleUnitSymbolsPane.class);
    private final Map<String, UnitButton> unitsMap = new HashMap<String, UnitButton>();

    public void addUnit(UnitRemote<? extends GeneratedMessage> unitRemoteObject, Point2D position, String locationId) throws CouldNotPerformException, InterruptedException {
        try {
            UnitButton newButton = new UnitButton(unitRemoteObject);
            newButton.setTranslateX(position.getY());
            newButton.setTranslateY(position.getX());
            this.unitsMap.put(locationId, newButton);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("UnitType[" + ((UnitConfigType.UnitConfig)unitRemoteObject.getConfig()).getType() + "] is not supported yet!", (Throwable)ex);
        }
    }

    public void clearUnits() {
        this.unitsMap.forEach((unitId, button) -> this.getChildren().remove((Object)button));
        this.unitsMap.clear();
    }

    public void updateUnitsPane() {
        this.getChildren().clear();
        this.unitsMap.forEach((unitId, button) -> this.getChildren().add((Object)button));
    }
}

