/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.generic;

import com.jfoenix.controls.JFXSlider;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.jul.visual.javafx.iface.DynamicPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.EmphasisStateType;

public class EmphasisAdjustment
extends GridPane
implements DynamicPane {
    protected final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final boolean comfort;
    private final boolean energy;
    private final boolean security;
    private final DoubleProperty comfortProperty;
    private final DoubleProperty energyProperty;
    private final DoubleProperty securityProperty;
    private JFXSlider comfortSlider;
    private JFXSlider energySlider;
    private JFXSlider securitySlider;

    public EmphasisAdjustment() {
        this(true, true, true);
    }

    public EmphasisAdjustment(boolean comfort, boolean energy, boolean security) {
        this.comfort = comfort;
        this.energy = energy;
        this.security = security;
        this.comfortProperty = new SimpleDoubleProperty(0.0);
        this.energyProperty = new SimpleDoubleProperty(0.0);
        this.securityProperty = new SimpleDoubleProperty(0.0);
    }

    public void updateDynamicContent() {
        if (this.comfortSlider != null && this.comfort) {
            this.comfortProperty.set(this.comfortSlider.getValue());
        }
        if (this.energySlider != null && this.energy) {
            this.energyProperty.set(this.energySlider.getValue());
        }
        if (this.securitySlider != null && this.security) {
            this.securityProperty.set(this.securitySlider.getValue());
        }
    }

    public void initContent() {
        int counter = 0;
        if (this.comfort) {
            this.comfortSlider = new JFXSlider(0.0, 100.0, 0.0);
            this.comfortSlider.getStyleClass().clear();
            ObserverLabel comfortLabel = new ObserverLabel("comfort");
            this.comfortSlider.valueProperty().addListener(observable -> {
                if (this.isHover()) {
                    this.comfortProperty.set(this.comfortSlider.getValue());
                }
            });
            EmphasisAdjustment.setConstraints((Node)comfortLabel, (int)0, (int)0);
            EmphasisAdjustment.setConstraints((Node)this.comfortSlider, (int)1, (int)0);
            this.getChildren().addAll((Object[])new Node[]{this.comfortSlider, comfortLabel});
            ++counter;
        }
        if (this.energy) {
            this.energySlider = new JFXSlider(0.0, 100.0, 0.0);
            this.energySlider.getStyleClass().clear();
            ObserverLabel energyLabel = new ObserverLabel("energy");
            this.energySlider.valueProperty().addListener(observable -> {
                if (this.isHover()) {
                    this.energyProperty.set(this.energySlider.getValue());
                }
            });
            EmphasisAdjustment.setConstraints((Node)energyLabel, (int)0, (int)counter);
            EmphasisAdjustment.setConstraints((Node)this.energySlider, (int)1, (int)counter);
            this.getChildren().addAll((Object[])new Node[]{this.energySlider, energyLabel});
            ++counter;
        }
        if (this.security) {
            this.securitySlider = new JFXSlider(0.0, 100.0, 0.0);
            this.securitySlider.getStyleClass().clear();
            ObserverLabel securityLabel = new ObserverLabel("security");
            this.securitySlider.valueProperty().addListener(observable -> {
                if (this.isHover()) {
                    this.securityProperty.set(this.securitySlider.getValue());
                }
            });
            EmphasisAdjustment.setConstraints((Node)securityLabel, (int)0, (int)counter);
            EmphasisAdjustment.setConstraints((Node)this.securitySlider, (int)1, (int)counter);
            this.getChildren().addAll((Object[])new Node[]{this.securitySlider, securityLabel});
        }
    }

    public DoubleProperty getComfortProperty() {
        return this.comfortProperty;
    }

    public DoubleProperty getEnergyProperty() {
        return this.energyProperty;
    }

    public DoubleProperty getSecurityProperty() {
        return this.securityProperty;
    }

    public EmphasisStateType.EmphasisState getCurrentEmphasisState() {
        EmphasisStateType.EmphasisState.Builder emphasisStateBuilder = EmphasisStateType.EmphasisState.newBuilder();
        if (this.comfort) {
            emphasisStateBuilder.setComfort(this.comfortSlider.getValue());
        }
        if (this.energy) {
            emphasisStateBuilder.setEnergy(this.energySlider.getValue());
        }
        if (this.security) {
            emphasisStateBuilder.setSecurity(this.securitySlider.getValue());
        }
        return emphasisStateBuilder.build();
    }

    public void setSelectedEmphasis(EmphasisStateType.EmphasisState emphasisState) {
        if (!this.isHover()) {
            if (this.comfort) {
                this.comfortSlider.setValue(emphasisState.getComfort());
            }
            if (this.energy) {
                this.energySlider.setValue(emphasisState.getEnergy());
            }
            if (this.security) {
                this.securitySlider.setValue(emphasisState.getSecurity());
            }
        }
    }
}

