/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import javafx.animation.FadeTransition;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.AnimationProvider;
import org.openbase.bco.bcozy.view.SVGIcon;

public class ConnectionPane
extends VBox {
    private final SVGIcon connectionSuccessView;
    private final SVGIcon connectionProblemView;
    private final SVGIcon connectionUploadView;
    private final SVGIcon connectionDownloadView;
    private final SVGIcon connectionSuccessViewSmall;
    private final SVGIcon connectionProblemViewSmall;
    private final SVGIcon connectionUploadViewSmall;
    private final SVGIcon connectionDownloadViewSmall;
    private boolean test;
    private final FadeTransition problemFade;
    private final FadeTransition problemFadeSmall;
    private final GridPane connectionIcon = new GridPane();
    private final GridPane connectionIconSmall = new GridPane();

    public ConnectionPane() {
        SVGIcon connectionView = new SVGIcon((GlyphIcons)FontAwesomeIcon.DATABASE, 40.0, true);
        SVGIcon connectionViewSmall = new SVGIcon((GlyphIcons)FontAwesomeIcon.DATABASE, 32.0, true);
        this.connectionSuccessView = new SVGIcon((GlyphIcons)FontAwesomeIcon.CHECK_CIRCLE, 16.0, true);
        this.connectionSuccessView.setOpacity(0.0);
        this.connectionSuccessViewSmall = new SVGIcon((GlyphIcons)FontAwesomeIcon.CHECK_CIRCLE, 16.0, true);
        this.connectionSuccessViewSmall.setOpacity(0.0);
        this.connectionProblemView = new SVGIcon((GlyphIcons)FontAwesomeIcon.QUESTION_CIRCLE, 16.0, true);
        this.connectionProblemView.setOpacity(0.0);
        this.connectionProblemViewSmall = new SVGIcon((GlyphIcons)FontAwesomeIcon.QUESTION_CIRCLE, 16.0, true);
        this.connectionProblemViewSmall.setOpacity(0.0);
        this.connectionUploadView = new SVGIcon((GlyphIcons)FontAwesomeIcon.ARROW_UP, 10.0, true);
        this.connectionUploadView.setOpacity(0.0);
        this.connectionUploadViewSmall = new SVGIcon((GlyphIcons)FontAwesomeIcon.ARROW_UP, 16.0, true);
        this.connectionUploadViewSmall.setOpacity(0.0);
        this.connectionDownloadView = new SVGIcon((GlyphIcons)FontAwesomeIcon.ARROW_DOWN, 10.0, true);
        this.connectionDownloadView.setOpacity(0.0);
        this.connectionDownloadViewSmall = new SVGIcon((GlyphIcons)FontAwesomeIcon.ARROW_DOWN, 16.0, true);
        this.connectionDownloadViewSmall.setOpacity(0.0);
        this.test = false;
        connectionView.setOnMouseClicked(event -> this.testAnimations());
        this.connectionIcon.add((Node)connectionView, 0, 0, 1, 2);
        this.connectionIcon.add((Node)this.connectionSuccessView, 1, 0);
        this.connectionIcon.add((Node)this.connectionProblemView, 1, 0);
        this.connectionIcon.add((Node)this.connectionUploadView, 1, 1);
        this.connectionIcon.add((Node)this.connectionDownloadView, 1, 1);
        this.connectionIcon.setHgap(2.0);
        this.connectionIcon.setAlignment(Pos.CENTER);
        connectionViewSmall.setOnMouseClicked(event -> this.testAnimationsSmall());
        this.connectionIconSmall.add((Node)connectionViewSmall, 0, 0, 1, 2);
        this.connectionIconSmall.add((Node)this.connectionSuccessViewSmall, 1, 0);
        this.connectionIconSmall.add((Node)this.connectionProblemViewSmall, 1, 0);
        this.connectionIconSmall.add((Node)this.connectionUploadViewSmall, 1, 1);
        this.connectionIconSmall.add((Node)this.connectionDownloadViewSmall, 1, 1);
        this.connectionIconSmall.setHgap(2.0);
        this.connectionIconSmall.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{this.connectionIcon});
        this.problemFade = AnimationProvider.createFadeTransition((Node)this.connectionProblemView, 1.0, 0.3, -1, 1000.0);
        this.problemFadeSmall = AnimationProvider.createFadeTransition((Node)this.connectionProblemViewSmall, 1.0, 0.3, -1, 1000.0);
    }

    private void testAnimations() {
        if (this.test) {
            this.connectionEstablished(this.connectionSuccessView, this.connectionProblemView, this.problemFade);
            this.uploadActive(this.connectionUploadView);
            this.test = false;
        } else {
            this.connectionProblem(this.connectionSuccessView, this.connectionProblemView, this.problemFade);
            this.downloadActive(this.connectionDownloadView);
            this.test = true;
        }
    }

    private void testAnimationsSmall() {
        if (this.test) {
            this.connectionEstablished(this.connectionSuccessViewSmall, this.connectionProblemViewSmall, this.problemFadeSmall);
            this.uploadActive(this.connectionUploadViewSmall);
            this.test = false;
        } else {
            this.connectionProblem(this.connectionSuccessViewSmall, this.connectionProblemViewSmall, this.problemFadeSmall);
            this.downloadActive(this.connectionDownloadViewSmall);
            this.test = true;
        }
    }

    public void connectionEstablished(SVGIcon successView, SVGIcon problemView, FadeTransition transition) {
        successView.setOpacity(1.0);
        successView.setForegroundIconColorAnimated(Color.LIMEGREEN, 1);
        transition.stop();
        problemView.setOpacity(0.0);
    }

    public void connectionProblem(SVGIcon successView, SVGIcon problemView, FadeTransition transition) {
        successView.setOpacity(0.0);
        problemView.setForegroundIconColorAnimated(Color.TOMATO, -1);
        transition.play();
    }

    public void uploadActive(SVGIcon uploadView) {
        uploadView.setOpacity(1.0);
        FadeTransition uploadFade = AnimationProvider.createFadeTransition((Node)uploadView, 0.0, 1.0, 1, 100.0);
        uploadFade.play();
        uploadFade.setOnFinished(event -> uploadView.setOpacity(0.0));
    }

    public void downloadActive(SVGIcon downloadView) {
        downloadView.setOpacity(1.0);
        FadeTransition downloadFade = AnimationProvider.createFadeTransition((Node)downloadView, 0.0, 1.0, 1, 100.0);
        downloadFade.play();
        downloadFade.setOnFinished(event -> downloadView.setOpacity(0.0));
    }

    public void maximize() {
        if (this.connectionIcon != null) {
            // empty if block
        }
    }

    public Node getStatusIcon() {
        return this.connectionIconSmall;
    }
}

