/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import com.google.protobuf.GeneratedMessage;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.Map;
import javafx.application.Platform;
import org.openbase.bco.authentication.lib.AuthorizationHelper;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.generic.ExpandableWidgedPane;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Initializable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.Remote;
import org.slf4j.Logger;
import rst.domotic.unit.UnitConfigType;

public abstract class AbstractUnitPane<UR extends UnitRemote<D>, D extends GeneratedMessage>
extends ExpandableWidgedPane
implements Initializable<UR>,
Shutdownable {
    private final Class<UR> unitRemoteClass;
    private UR unitRemote;
    private final Observer<UnitConfigType.UnitConfig> unitConfigObserver;
    private final Observer<D> unitDataObserver;
    private final Observer<Remote.ConnectionState> unitConnectionObserver;
    private final Observer<String> loginObserver;

    public AbstractUnitPane(Class<UR> unitRemoteClass, boolean activateable) {
        super(false, activateable);
        this.unitRemoteClass = unitRemoteClass;
        this.unitConfigObserver = new Observer<UnitConfigType.UnitConfig>(){

            public void update(Observable<UnitConfigType.UnitConfig> source, UnitConfigType.UnitConfig config) throws Exception {
                Platform.runLater(() -> {
                    try {
                        AbstractUnitPane.this.applyConfigUpdate(config);
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((String)("Could not apply config update on " + this), (Throwable)ex, (Logger)AbstractUnitPane.this.LOGGER);
                    }
                });
            }
        };
        this.unitDataObserver = new Observer<D>(){

            public void update(Observable<D> source, D data) throws Exception {
                Platform.runLater(() -> {
                    try {
                        AbstractUnitPane.this.applyDataUpdate(data);
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((String)("Could not apply data update on " + this), (Throwable)ex, (Logger)AbstractUnitPane.this.LOGGER);
                    }
                });
            }
        };
        this.unitConnectionObserver = new Observer<Remote.ConnectionState>(){

            public void update(Observable<Remote.ConnectionState> source, Remote.ConnectionState connectionState) throws Exception {
                Platform.runLater(() -> {
                    try {
                        AbstractUnitPane.this.applyConnectionStateUpdate(connectionState);
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((String)("Could not apply data update on " + this), (Throwable)ex, (Logger)AbstractUnitPane.this.LOGGER);
                    }
                });
            }
        };
        this.loginObserver = new Observer<String>(){

            public void update(Observable<String> source, String authority) throws Exception {
                Platform.runLater(() -> {
                    try {
                        AbstractUnitPane.this.applyLoginUpdate();
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((String)("Could not apply data update on " + this), (Throwable)ex, (Logger)AbstractUnitPane.this.LOGGER);
                    }
                });
            }
        };
    }

    public void init(String unitId) throws InterruptedException, InitializationException {
        try {
            this.init((UR)Units.getUnit((String)unitId, (boolean)false, this.unitRemoteClass));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(UnitConfigType.UnitConfig unitConfig) throws InterruptedException, InitializationException {
        try {
            this.init((UR)Units.getUnit((UnitConfigType.UnitConfig)unitConfig, (boolean)false, this.unitRemoteClass));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(UR unitRemote) throws InterruptedException, InitializationException {
        this.init();
        this.clearRemoteObservers();
        this.unitRemote = unitRemote;
        unitRemote.addConfigObserver(this.unitConfigObserver);
        unitRemote.addDataObserver(this.unitDataObserver);
        unitRemote.addConnectionStateObserver(this.unitConnectionObserver);
        SessionManager.getInstance().addLoginObserver(this.loginObserver);
        if (!unitRemote.isConnected()) {
            this.setDisable(false);
        }
        try {
            this.applyConnectionStateUpdate(unitRemote.getConnectionState());
        }
        catch (CouldNotPerformException couldNotPerformException) {
            // empty catch block
        }
        try {
            this.applyConfigUpdate((UnitConfigType.UnitConfig)unitRemote.getConfig());
        }
        catch (CouldNotPerformException couldNotPerformException) {
            // empty catch block
        }
        try {
            this.applyDataUpdate((GeneratedMessage)unitRemote.getData());
        }
        catch (CouldNotPerformException couldNotPerformException) {
            // empty catch block
        }
        try {
            this.applyLoginUpdate();
        }
        catch (CouldNotPerformException couldNotPerformException) {
            // empty catch block
        }
    }

    @Override
    public void initContent() {
        super.initContent();
        this.hoverProperty().addListener((observable, oldValue, newValue) -> {
            try {
                InfoPane.info(this.getUnitStateDescription());
            }
            catch (NotAvailableException ex) {
                ExceptionPrinter.printHistory((String)"Could not print unit state description!", (Throwable)ex, (Logger)this.LOGGER);
            }
        });
    }

    private void clearRemoteObservers() {
        if (this.unitRemote != null) {
            this.unitRemote.removeConfigObserver(this.unitConfigObserver);
            this.unitRemote.removeDataObserver(this.unitDataObserver);
            this.unitRemote.removeConnectionStateObserver(this.unitConnectionObserver);
        }
    }

    public UR getUnitRemote() throws NotAvailableException {
        if (this.unitRemote == null) {
            throw new NotAvailableException("UnitRemote");
        }
        return this.unitRemote;
    }

    public D getData() throws NotAvailableException {
        return (D)((GeneratedMessage)this.getUnitRemote().getData());
    }

    public String getUnitStateDescription() throws NotAvailableException {
        return this.getUnitRemote().getLabel();
    }

    public void shutdown() {
        this.clearRemoteObservers();
    }

    protected void applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException {
        this.setLabel(config.getLabel());
    }

    protected void applyDataUpdate(D data) throws CouldNotPerformException {
        this.updateDynamicContent();
    }

    protected void applyConnectionStateUpdate(Remote.ConnectionState connectionState) throws CouldNotPerformException {
        switch (connectionState) {
            case CONNECTED: {
                this.setDisable(false);
                break;
            }
            default: {
                this.setDisable(true);
            }
        }
    }

    protected void applyLoginUpdate() throws CouldNotPerformException {
        try {
            String userAtClientId = null;
            Map groups = null;
            Map locations = Registries.getUnitRegistry().getLocationUnitConfigRemoteRegistry().getEntryMap();
            if (SessionManager.getInstance().isLoggedIn()) {
                userAtClientId = SessionManager.getInstance().getUserAtClientId();
                groups = Registries.getUnitRegistry().getAuthorizationGroupUnitConfigRemoteRegistry().getEntryMap();
            }
            this.disableProperty().set(!AuthorizationHelper.canAccess((UnitConfigType.UnitConfig)((UnitConfigType.UnitConfig)this.unitRemote.getConfig()), (String)userAtClientId, (Map)groups, (Map)locations));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + (this.unitRemote != null ? this.unitRemote : "?") + "]";
    }

    public SVGIcon getIconSymbol() {
        return new SVGIcon((GlyphIcons)MaterialDesignIcon.VECTOR_CIRCLE, 32.0, false);
    }
}

