/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.BatteryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import rst.domotic.unit.dal.BatteryDataType;

public class BatteryPane
extends AbstractUnitPane<BatteryRemote, BatteryDataType.BatteryData> {
    public BatteryPane() {
        super(BatteryRemote.class, false);
        this.setIcon((GlyphIcons)MaterialDesignIcon.BATTERY_OUTLINE, (GlyphIcons)MaterialDesignIcon.BATTERY);
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        try {
            double level = ((BatteryDataType.BatteryData)((BatteryRemote)this.getUnitRemote()).getData()).getBatteryState().getLevel();
            if (level > 90.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY);
            } else if (level > 80.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_90);
            } else if (level > 70.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_80);
            } else if (level > 60.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_70);
            } else if (level > 50.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_60);
            } else if (level > 40.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_50);
            } else if (level > 30.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_40);
            } else if (level > 20.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_30);
            } else if (level > 10.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_20);
            } else if (level > 5.0) {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_10);
            } else {
                this.getIcon().setBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_ALERT);
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        try {
            switch (((BatteryDataType.BatteryData)((BatteryRemote)this.getUnitRemote()).getData()).getBatteryState().getValue()) {
                case UNKNOWN: {
                    this.getIcon().setBackgroundIconColor(Color.BLACK);
                    break;
                }
                case OK: {
                    this.getIcon().setBackgroundIconColor(Color.GREEN);
                    break;
                }
                case CRITICAL: {
                    this.getIcon().setBackgroundIconColor(Color.ORANGE);
                    this.getIcon().startBackgroundIconColorFadeAnimation(-1);
                    break;
                }
                case INSUFFICIENT: {
                    this.getIcon().setBackgroundIconColor(Color.RED);
                    this.getIcon().startBackgroundIconColorFadeAnimation(-1);
                    break;
                }
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.LOGGER, (LogLevel)LogLevel.ERROR);
            this.getIcon().setBackgroundIconColor(Color.BLACK);
        }
    }
}

