/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.fxml.FXML;
import javafx.scene.control.PasswordField;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.bcozy.controller.AbstractCurrentUserAwareController;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordChangeController
extends AbstractCurrentUserAwareController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordChangeController.class);
    private static final String PASSWORD_FIELD_WRONG_CLASS = "password-field-wrong";
    @FXML
    private PasswordField oldPassword;
    @FXML
    private PasswordField newPassword;
    @FXML
    private PasswordField repeatedPassword;
    @FXML
    private ObserverButton savePassword;
    private Consumer<Boolean> onPasswordChange = success -> {};

    public void initialize() {
        this.savePassword.setApplyOnNewText(String::toUpperCase);
    }

    @FXML
    private void saveNewPassword() throws InterruptedException {
        this.clearHints();
        if (!this.verifyNewPassword()) {
            InfoPane.warn("passwordsNotEqual").hideAfter(Duration.seconds((double)5.0));
            this.clearPasswordFields();
            this.newPassword.getStyleClass().add((Object)PASSWORD_FIELD_WRONG_CLASS);
            this.repeatedPassword.getStyleClass().add((Object)PASSWORD_FIELD_WRONG_CLASS);
            this.onPasswordChange.accept(false);
            return;
        }
        try {
            SessionManager.getInstance().changeCredentials(this.getUserId(), this.oldPassword.getText(), this.newPassword.getText());
            this.onPasswordChange.accept(true);
            this.showSuccessMessage();
        }
        catch (RejectedException rex) {
            this.oldPassword.getStyleClass().add((Object)PASSWORD_FIELD_WRONG_CLASS);
            this.onPasswordChange.accept(false);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            this.onPasswordChange.accept(false);
        }
        this.clearPasswordFields();
    }

    private void clearPasswordFields() {
        this.oldPassword.clear();
        this.newPassword.clear();
        this.repeatedPassword.clear();
    }

    private void clearHints() {
        this.oldPassword.getStyleClass().remove((Object)PASSWORD_FIELD_WRONG_CLASS);
        this.newPassword.getStyleClass().remove((Object)PASSWORD_FIELD_WRONG_CLASS);
        this.repeatedPassword.getStyleClass().remove((Object)PASSWORD_FIELD_WRONG_CLASS);
    }

    private boolean verifyNewPassword() {
        return this.newPassword.getText().equals(this.repeatedPassword.getText());
    }

    private void showSuccessMessage() {
        InfoPane.info("saveSuccess").backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
    }

    public void setOnPasswordChange(Consumer<Boolean> onPasswordChange) {
        this.onPasswordChange = Objects.requireNonNull(onPasswordChange);
    }
}

