/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller.group;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import org.openbase.bco.bcozy.controller.ButtonTableCellFactory;
import org.openbase.bco.bcozy.controller.Dialog;
import org.openbase.bco.bcozy.controller.group.AuthorizationGroupUsersController;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.util.AuthorizationGroups;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.ExceptionProcessor;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class AuthorizationGroupController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationGroupController.class);
    @FXML
    private ObserverButton saveButton;
    @FXML
    private TextField label;
    @FXML
    private TableColumn<UnitConfigType.UnitConfig, String> removeColumn;
    @FXML
    private TableColumn<UnitConfigType.UnitConfig, String> nameColumn;
    @FXML
    private TableView<UnitConfigType.UnitConfig> groupsTable;
    @FXML
    private AuthorizationGroupUsersController authorizationGroupUsersController;
    @FXML
    private VBox authorizationGroupUsers;
    @FXML
    private Pane root;
    private ObservableList<UnitConfigType.UnitConfig> groups = AuthorizationGroups.getAuthorizationGroups();
    private UnitConfigType.UnitConfig lastSelectedUnit;

    @FXML
    public void initialize() {
        this.saveButton.setApplyOnNewText(String::toUpperCase);
        this.nameColumn.setCellValueFactory(param -> new SimpleStringProperty(((UnitConfigType.UnitConfig)param.getValue()).getLabel()));
        LanguageSelection.addObserverFor("groupLabel", (locale, text) -> this.nameColumn.setText(text));
        this.removeColumn.setCellFactory(new ButtonTableCellFactory((group, cellIndex) -> this.removeGroup((UnitConfigType.UnitConfig)group), () -> new SVGIcon((GlyphIcons)FontAwesomeIcon.TIMES, 16.0, true)));
        this.groupsTable.widthProperty().addListener((observable, oldValue, newValue) -> this.nameColumn.setPrefWidth(newValue.doubleValue() - this.removeColumn.getWidth() - 2.0));
        this.groupsTable.setEditable(false);
        this.nameColumn.setResizable(false);
        this.removeColumn.setResizable(false);
        this.groupsTable.setItems(this.groups);
        this.authorizationGroupUsersController.selectedGroupProperty().bind((ObservableValue)this.groupsTable.getSelectionModel().selectedItemProperty());
        LanguageSelection.addObserverFor("groupLabel", (locale, text) -> this.label.setPromptText(text));
        AuthorizationGroups.addListObserver(this::showGroups);
    }

    private void showGroups(List<UnitConfigType.UnitConfig> groups) {
        if (this.groupsTable.getSelectionModel().getSelectedItem() != null) {
            this.lastSelectedUnit = (UnitConfigType.UnitConfig)this.groupsTable.getSelectionModel().getSelectedItem();
        }
        this.groupsTable.setItems(FXCollections.observableArrayList(groups));
        this.reselectLastUnit();
    }

    private void reselectLastUnit() {
        if (this.lastSelectedUnit != null) {
            String id = this.lastSelectedUnit.getId();
            for (UnitConfigType.UnitConfig group : this.groups) {
                if (!group.getId().equals(id)) continue;
                this.groupsTable.getSelectionModel().select((Object)group);
                return;
            }
        }
        this.groupsTable.getSelectionModel().select(null);
    }

    public Pane getRoot() {
        return this.root;
    }

    private void removeGroup(UnitConfigType.UnitConfig group) {
        if (!Dialog.getConfirmation("removeGroup.confirmation", group.getLabel())) {
            return;
        }
        try {
            AuthorizationGroups.removeAuthorizationGroup(group);
            InfoPane.info("deleteSuccess").backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            String message = LanguageSelection.getLocalized("deleteErrorWithMessage", ExceptionProcessor.getInitialCauseMessage((Throwable)ex));
            InfoPane.info(message).backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
        }
    }

    @FXML
    private void addGroup() {
        try {
            this.lastSelectedUnit = AuthorizationGroups.addAuthorizationGroup(this.label.getText());
            this.groupsTable.getSelectionModel().select(null);
            this.label.clear();
            InfoPane.info("saveSuccess").backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            this.label.getStyleClass().add((Object)"text-field-wrong");
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            String message = LanguageSelection.getLocalized("saveErrorWithMessage", ExceptionProcessor.getInitialCauseMessage((Throwable)ex));
            InfoPane.info(message).backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
        }
    }
}

