/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.model;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Observable;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageSelection
extends Observable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageSelection.class);
    private static LanguageSelection instance;

    private LanguageSelection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanguageSelection getInstance() {
        Class<LanguageSelection> clazz = LanguageSelection.class;
        synchronized (LanguageSelection.class) {
            if (instance == null) {
                instance = new LanguageSelection();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setSelectedLocale(Locale selectedLocale) {
        this.setChanged();
        Locale.setDefault(selectedLocale);
        this.notifyObservers(Locale.getDefault());
    }

    public static String getLocalized(String identifier) {
        return LanguageSelection.getLocalized(identifier, new Object[0]);
    }

    public static String getLocalized(String identifier, Object ... args) {
        String text;
        Objects.requireNonNull(identifier);
        try {
            text = ResourceBundle.getBundle("languages.languages", Locale.getDefault()).getString(identifier);
            for (int i = 0; i < args.length; ++i) {
                text = text.replace("{" + i + "}", Objects.toString(args[i]));
            }
        }
        catch (MissingResourceException ex) {
            if (JPService.verboseMode()) {
                ExceptionPrinter.printHistory((String)("Could not resolve Identifier[" + identifier + "]"), (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.WARN);
            } else {
                ExceptionPrinter.printHistory((String)("Could not resolve Identifier[" + identifier + "]"), (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.DEBUG);
            }
            text = identifier;
        }
        return text;
    }

    public static void addObserverFor(String identifier, OnLanguageChangeListener onLanguageChangeListener) {
        LanguageSelection.getInstance().addObserver((o, arg) -> onLanguageChangeListener.onLanguageChange(Locale.getDefault(), LanguageSelection.getLocalized(identifier)));
        onLanguageChangeListener.onLanguageChange(Locale.getDefault(), LanguageSelection.getLocalized(identifier));
    }

    public static void addObserverFor(String identifier, Consumer<String> newTextConsumer) {
        LanguageSelection.getInstance().addObserver((o, arg) -> newTextConsumer.accept(LanguageSelection.getLocalized(identifier)));
        newTextConsumer.accept(LanguageSelection.getLocalized(identifier));
    }

    public static ReadOnlyStringProperty getProperty(String identifier) {
        ReadOnlyStringWrapper localizedProperty = new ReadOnlyStringWrapper();
        LanguageSelection.addObserverFor(identifier, (Locale locale, String text) -> localizedProperty.set(text));
        return localizedProperty.getReadOnlyProperty();
    }

    public static interface OnLanguageChangeListener {
        public void onLanguageChange(Locale var1, String var2);
    }
}

