/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.permissions;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.permissions.model.GroupPermissions;
import org.openbase.bco.bcozy.permissions.model.OtherPermissions;
import org.openbase.bco.bcozy.permissions.model.OwnerPermissions;
import org.openbase.bco.bcozy.permissions.model.PermissionsService;
import org.openbase.bco.bcozy.permissions.model.PermissionsServiceImpl;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.ExceptionProcessor;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitPermissionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitPermissionController.class);
    @FXML
    private TableView<Object> permissionsTable;
    @FXML
    public TableColumn<GroupPermissions, String> groupColumn;
    @FXML
    public TableColumn<GroupPermissions, Boolean> accessColumn;
    @FXML
    public TableColumn<GroupPermissions, Boolean> writeColumn;
    @FXML
    public TableColumn<GroupPermissions, Boolean> readColumn;
    protected PermissionsService permissionsService = PermissionsServiceImpl.INSTANCE;
    private String selectedUnitId;
    private OwnerPermissions ownerPermissions;
    private OtherPermissions other;
    private List<GroupPermissions> groupPermissions;

    @FXML
    public void initialize() {
        this.permissionsTable.setEditable(true);
        this.permissionsTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.groupColumn.setMaxWidth(8.589934592E10);
        this.accessColumn.setMaxWidth(4.294967296E10);
        this.writeColumn.setMaxWidth(4.294967296E10);
        this.readColumn.setMaxWidth(4.294967296E10);
        Arrays.asList(this.accessColumn, this.readColumn, this.writeColumn).forEach(column -> column.setComparator(Boolean::compare));
    }

    public void setSelectedUnitId(String selectedUnitId) {
        this.selectedUnitId = selectedUnitId;
        try {
            this.permissionsTable.getItems().clear();
            this.groupPermissions = this.permissionsService.getUnitPermissions(selectedUnitId);
            this.other = this.permissionsService.getOtherPermissions(selectedUnitId);
            this.ownerPermissions = this.permissionsService.getOwner(selectedUnitId);
            this.permissionsTable.getItems().add((Object)this.ownerPermissions);
            this.permissionsTable.getItems().add((Object)this.other);
            this.permissionsTable.getItems().addAll(this.groupPermissions);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @FXML
    public void save() {
        try {
            this.permissionsService.save(this.selectedUnitId, this.groupPermissions, this.ownerPermissions, this.other);
            InfoPane.info("saveSuccess").backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
        }
        catch (ExecutionException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            String message = LanguageSelection.getLocalized("saveErrorWithMessage", ExceptionProcessor.getInitialCauseMessage((Throwable)ex));
            InfoPane.info(message).backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

