/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import com.sun.javafx.application.PlatformImpl;
import java.util.Objects;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import org.openbase.bco.bcozy.BCozy;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPane
extends BorderPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoPane.class);
    private static InfoPane instance;
    private final ObserverLabel textLabel = new ObserverLabel();
    private Timeline timeline;

    public InfoPane(double height, double width) {
        this.textLabel.getStyleClass().add((Object)"floating-label");
        this.textLabel.setAlignment(Pos.CENTER);
        this.setCenter((Node)this.textLabel);
        this.setPrefHeight(height);
        this.setPrefWidth(width);
        instance = this;
    }

    public static InfoPane getInstance() throws NotAvailableException {
        if (instance == null) {
            throw new NotAvailableException("InfoPane", (Throwable)new InvalidStateException("InfoPane not initialized!"));
        }
        return instance;
    }

    @Deprecated
    public Label getMouseOverText() {
        return this.textLabel;
    }

    public static InfoPaneConfigurer info(String identifier) {
        String style = BCozy.baseColorIsWhite ? "-fx-text-fill: white;" : "-fx-text-fill: black;";
        return InfoPane.show(identifier, style);
    }

    public static InfoPaneConfigurer confirmation(String identifier) {
        return InfoPane.show(identifier, "-fx-text-fill: green;");
    }

    public static InfoPaneConfigurer warn(String identifier) {
        return InfoPane.show(identifier, "-fx-text-fill: orange;");
    }

    public static InfoPaneConfigurer error(String identifier) {
        return InfoPane.show(identifier, "-fx-text-fill: red;");
    }

    public static InfoPaneConfigurer show(String identifier, String style) {
        return InfoPane.show(identifier, style, "");
    }

    public static InfoPaneConfigurer show(String identifier, String style, String infopaneStyle) {
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(style);
        try {
            InfoPane infoPane = InfoPane.getInstance();
            infoPane.resetTimeline();
            Platform.runLater(() -> {
                infoPane.clearBackground();
                infoPane.setStyle(infopaneStyle);
                infoPane.textLabel.setStyle(style + "-fx-font-size: 16;");
                infoPane.textLabel.setIdentifier(identifier);
            });
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not print user feedback!", (Throwable)ex, (Logger)LOGGER);
        }
        return new InfoPaneConfigurer();
    }

    public static void hide() {
        try {
            InfoPane.show("", "");
            InfoPane.getInstance().clearBackground();
            InfoPane.getInstance().resetTimeline();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not print user feedback!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    private void clearBackground() {
        this.setBackground(null);
    }

    private void resetTimeline() throws NotAvailableException {
        if (this.timeline != null) {
            this.timeline.stop();
        }
        this.timeline = null;
    }

    public static class InfoPaneConfigurer {
        private InfoPaneConfigurer() {
        }

        public InfoPaneConfigurer hideAfter(Duration duration) {
            PlatformImpl.runLater(() -> {
                try {
                    InfoPane.getInstance().resetTimeline();
                    InfoPane.getInstance().timeline = new Timeline(new KeyFrame[]{new KeyFrame(duration, e -> InfoPane.hide(), new KeyValue[0])});
                    InfoPane.getInstance().timeline.play();
                }
                catch (NotAvailableException ex) {
                    ExceptionPrinter.printHistory((String)"Could not print user feedback!", (Throwable)ex, (Logger)LOGGER);
                }
            });
            return this;
        }

        public InfoPaneConfigurer backgroundColor(Color color) {
            PlatformImpl.runLater(() -> {
                try {
                    InfoPane.getInstance().setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)}));
                }
                catch (NotAvailableException ex) {
                    ExceptionPrinter.printHistory((String)"Could not print user feedback!", (Throwable)ex, (Logger)LOGGER);
                }
            });
            return this;
        }
    }
}

