/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.Future;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.PowerSwitchRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.PowerSwitchDataType;

public class PowerSwitchPane
extends AbstractUnitPane<PowerSwitchRemote, PowerSwitchDataType.PowerSwitchData> {
    public PowerSwitchPane() {
        super(PowerSwitchRemote.class, true);
        this.getIcon().setForegroundIcon((GlyphIcons)MaterialDesignIcon.POWER);
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        PowerStateType.PowerState.State state = PowerStateType.PowerState.State.UNKNOWN;
        try {
            state = ((PowerSwitchDataType.PowerSwitchData)((PowerSwitchRemote)this.getUnitRemote()).getData()).getPowerState().getValue();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        switch (state) {
            case ON: {
                this.getIcon().setForegroundIconColor(Color.GREEN);
                this.setPrimaryActivationWithoutNotification(Boolean.TRUE);
                break;
            }
            case OFF: {
                this.getIcon().setForegroundIconColor(Color.BLACK);
                this.setPrimaryActivationWithoutNotification(Boolean.FALSE);
            }
        }
    }

    @Override
    protected Future applyPrimaryActivationUpdate(boolean activation) throws CouldNotPerformException {
        return activation ? ((PowerSwitchRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.ON) : ((PowerSwitchRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.OFF);
    }
}

