/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.util;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openbase.bco.bcozy.util.FileLanguagesDetector;
import org.openbase.bco.bcozy.util.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Languages {
    private static final Logger LOGGER = LoggerFactory.getLogger(Languages.class);
    private final Language fallback = new Language(Locale.US);
    private final List<Language> languages = new FileLanguagesDetector().getLanguages();

    public static Languages getInstance() {
        return InstanceHolder.INSTANCE;
    }

    Languages() {
    }

    @Nonnull
    public Language get(Locale locale) {
        return this.languages.stream().filter(l -> Objects.equals(l.getLocale(), locale)).findAny().orElse(this.fallback);
    }

    @Nonnull
    public Language get(String name) {
        return this.languages.stream().filter(l -> Objects.equals(l.getName(), name)).findAny().orElse(this.fallback);
    }

    @Nonnull
    public List<Language> get() {
        return this.languages;
    }

    private static final class InstanceHolder {
        static final Languages INSTANCE = new Languages();

        private InstanceHolder() {
        }
    }
}

