/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.view.AnimationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVGIcon
extends StackPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVGIcon.class);
    private Text backgroundIcon;
    private Text backgroundFadeIcon;
    private Text foregroundIcon;
    private Text foregroundFadeIcon;
    private final double size;
    private final boolean styled;
    private FadeTransition foregroundColorFadeAnimation;
    private FadeTransition backgroundIconColorFadeAnimation;
    private RotateTransition foregroundRotateAnimation;
    private RotateTransition backgroundRotateAnimation;
    private IconState iconState;

    public SVGIcon(GlyphIcons icon, double size, boolean styled) {
        this(size, styled);
        this.foregroundIcon = this.createIcon(icon, Layer.FOREGROUND);
        this.foregroundFadeIcon = this.createColorFadeIcon(icon, Layer.FOREGROUND);
        this.backgroundIcon = null;
        this.backgroundFadeIcon = null;
        this.getChildren().addAll((Object[])new Node[]{this.foregroundIcon, this.foregroundFadeIcon});
    }

    public SVGIcon(GlyphIcons backgroundIcon, GlyphIcons foregroundIcon, double size) {
        this(size, true);
        this.foregroundIcon = this.createIcon(foregroundIcon, Layer.FOREGROUND);
        this.foregroundFadeIcon = this.createColorFadeIcon(foregroundIcon, Layer.FOREGROUND);
        this.backgroundIcon = this.createIcon(backgroundIcon, Layer.BACKGROUND);
        this.backgroundFadeIcon = this.createColorFadeIcon(backgroundIcon, Layer.BACKGROUND);
        this.getChildren().addAll((Object[])new Node[]{this.backgroundIcon, this.backgroundFadeIcon, this.foregroundIcon, this.foregroundFadeIcon});
    }

    public SVGIcon(double size, boolean styled) {
        this.size = size;
        this.styled = styled;
        this.disableProperty().addListener((observable, oldValue, disabled) -> {
            if (disabled.booleanValue()) {
                this.iconState.save(this);
                this.stopIconAnimation();
                this.setForegroundIconColor(Color.GRAY);
                this.setBackgroundIconColor(Color.GRAY);
            } else {
                this.iconState.restore(this);
            }
        });
    }

    private Text createIcon(GlyphIcons glyphIcon, Layer layer) {
        return SVGIcon.createIcon(glyphIcon, this.size, layer == Layer.FOREGROUND && this.styled);
    }

    private static Text createIcon(GlyphIcons glyphIcon, double size, boolean styled) {
        Text icon = GlyphsDude.createIcon((GlyphIcons)glyphIcon, (String)String.valueOf(size));
        icon.setSmooth(true);
        if (styled) {
            icon.getStyleClass().clear();
            icon.getStyleClass().add((Object)"icons");
        }
        return icon;
    }

    private Text createColorFadeIcon(GlyphIcons glyphIcon, Layer layer) {
        return SVGIcon.createColorFadeIcon(glyphIcon, this.size, layer);
    }

    private static Text createColorFadeIcon(GlyphIcons glyphIcon, double size, Layer layer) {
        Text icon = SVGIcon.createIcon(glyphIcon, size, layer == Layer.FOREGROUND);
        icon.setOpacity(0.0);
        return icon;
    }

    public void fadeForegroundIconColorFromTransparentToOpaque(int cycleCount) {
        this.stopForegroundIconColorFadeAnimation();
        this.foregroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.foregroundIcon, 0.0, 1.0, cycleCount, 2000.0);
        this.foregroundColorFadeAnimation.setOnFinished(event -> this.foregroundIcon.setOpacity(1.0));
        this.foregroundColorFadeAnimation.play();
    }

    public void fadeForegroundIconColorFromOpaqueToTransparent(int cycleCount) {
        this.stopForegroundIconColorFadeAnimation();
        this.foregroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.foregroundIcon, 1.0, 0.0, cycleCount, 2000.0);
        this.foregroundColorFadeAnimation.setOnFinished(event -> this.foregroundIcon.setOpacity(0.0));
        this.foregroundColorFadeAnimation.play();
    }

    public void fadeBackgroundIconColorFromTransparentToOpaque(int cycleCount) {
        this.stopBackgroundIconColorFadeAnimation();
        this.backgroundIconColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.backgroundIcon, 0.0, 1.0, 1, 2000.0);
        this.backgroundIconColorFadeAnimation.setOnFinished(event -> this.backgroundIcon.setOpacity(1.0));
        this.backgroundIconColorFadeAnimation.play();
    }

    public void fadeBackgroundIconColorFromOpaqueToTransparent(int cycleCount) {
        this.stopBackgroundIconColorFadeAnimation();
        this.backgroundIconColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.backgroundIcon, 1.0, 0.0, cycleCount, 2000.0);
        this.backgroundIconColorFadeAnimation.setOnFinished(event -> this.backgroundIcon.setOpacity(0.0));
        this.backgroundIconColorFadeAnimation.play();
    }

    public void startForegroundIconColorFadeAnimation(int cycleCount) {
        this.foregroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.foregroundIcon, 0.0, 1.0, cycleCount, 2000.0);
        this.foregroundColorFadeAnimation.setOnFinished(event -> this.foregroundIcon.setOpacity(0.0));
        this.foregroundColorFadeAnimation.play();
    }

    public void startBackgroundIconColorFadeAnimation(int cycleCount) {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background animation skipped because background icon not set!");
            return;
        }
        this.backgroundIconColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.backgroundIcon, 0.0, 1.0, cycleCount, 2000.0);
        this.backgroundIconColorFadeAnimation.setOnFinished(event -> this.backgroundIcon.setOpacity(0.0));
        this.backgroundIconColorFadeAnimation.play();
    }

    public void stopForegroundIconColorFadeAnimation() {
        if (this.foregroundColorFadeAnimation != null) {
            this.foregroundColorFadeAnimation.stop();
        }
    }

    public void stopBackgroundIconColorFadeAnimation() {
        if (this.backgroundIconColorFadeAnimation != null) {
            this.backgroundIconColorFadeAnimation.stop();
        }
    }

    public void stopIconColorFadeAnimation() {
        this.stopForegroundIconColorFadeAnimation();
        this.stopBackgroundIconColorFadeAnimation();
    }

    public void startForegroundIconColorFadeAnimation() {
        if (this.foregroundColorFadeAnimation != null) {
            this.foregroundColorFadeAnimation.play();
        }
    }

    public void startBackgroundIconColorFadeAnimation() {
        if (this.backgroundIconColorFadeAnimation != null) {
            this.backgroundIconColorFadeAnimation.play();
        }
    }

    public void startIconColorFadeAnimation() {
        this.startForegroundIconColorFadeAnimation();
        this.startBackgroundIconColorFadeAnimation();
    }

    public void setForegroundIconColorAnimated(Color color, int cycleCount) {
        assert (color != null);
        this.stopForegroundIconColorFadeAnimation();
        this.foregroundFadeIcon.setFill((Paint)color);
        this.foregroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.foregroundFadeIcon, 0.0, 1.0, -1, 400.0);
        this.foregroundColorFadeAnimation.setOnFinished(event -> {
            this.foregroundFadeIcon.setFill((Paint)color);
            this.foregroundFadeIcon.setOpacity(0.0);
        });
        this.foregroundColorFadeAnimation.play();
    }

    public void setBackgroundIconColorAnimated(Color color, int cycleCount) {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background modification skipped because background icon not set!");
            return;
        }
        this.stopBackgroundIconColorFadeAnimation();
        this.backgroundFadeIcon.setFill((Paint)color);
        this.backgroundIconColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.backgroundFadeIcon, 0.0, 1.0, cycleCount, 400.0);
        this.backgroundIconColorFadeAnimation.setOnFinished(event -> {
            this.backgroundFadeIcon.setFill((Paint)color);
            this.backgroundFadeIcon.setOpacity(0.0);
        });
        this.backgroundIconColorFadeAnimation.play();
    }

    public void startForegroundIconRotateAnimation(double fromAngle, double toAngle, int cycleCount, double duration, Interpolator interpolator, boolean autoReverse) {
        this.stopForegroundIconRotateAnimation();
        this.foregroundRotateAnimation = AnimationProvider.createRotateTransition((Node)this.foregroundIcon, fromAngle, toAngle, cycleCount, duration, interpolator, autoReverse);
        this.foregroundRotateAnimation.setOnFinished(event -> this.foregroundIcon.setRotate(0.0));
        this.foregroundRotateAnimation.play();
    }

    public void startBackgroundIconRotateAnimation(double fromAngle, double toAngle, int cycleCount, double duration, Interpolator interpolator, boolean autoReverse) {
        this.stopBackgroundIconRotateAnimation();
        this.backgroundRotateAnimation = AnimationProvider.createRotateTransition((Node)this.backgroundIcon, fromAngle, toAngle, cycleCount, duration, interpolator, autoReverse);
        this.backgroundRotateAnimation.setOnFinished(event -> this.backgroundIcon.setRotate(0.0));
        this.backgroundRotateAnimation.play();
    }

    public void stopForegroundIconRotateAnimation() {
        if (this.foregroundRotateAnimation != null) {
            this.foregroundRotateAnimation.stop();
        }
    }

    public void stopBackgroundIconRotateAnimation() {
        if (this.backgroundRotateAnimation != null) {
            this.backgroundRotateAnimation.stop();
        }
    }

    public void stopIconRotateAnimation() {
        this.stopForegroundIconRotateAnimation();
        this.stopBackgroundIconRotateAnimation();
    }

    public void startForegroundIconRotateAnimation() {
        if (this.foregroundRotateAnimation != null) {
            this.foregroundRotateAnimation.play();
        }
    }

    public void startBackgroundIconRotateAnimation() {
        if (this.backgroundRotateAnimation != null) {
            this.backgroundRotateAnimation.play();
        }
    }

    public void startIconRotateAnimation() {
        this.startForegroundIconRotateAnimation();
        this.startBackgroundIconRotateAnimation();
    }

    public void stopIconAnimation() {
        this.stopIconColorFadeAnimation();
        this.stopIconRotateAnimation();
    }

    public void startIconAnimation() {
        this.startIconColorFadeAnimation();
        this.startIconRotateAnimation();
    }

    public void setForegroundIconColor(Color color) {
        this.stopForegroundIconColorFadeAnimation();
        this.foregroundIcon.setFill((Paint)color);
        this.foregroundIcon.setStroke((Paint)Color.TRANSPARENT);
        this.foregroundIcon.setStrokeWidth(0.0);
        this.foregroundFadeIcon.setFill((Paint)Color.TRANSPARENT);
    }

    public void setBackgroundIconColor(Color color) {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background modification skipped because background icon not set!");
            return;
        }
        this.stopBackgroundIconColorFadeAnimation();
        this.backgroundIcon.setFill((Paint)color);
        this.backgroundFadeIcon.setFill((Paint)Color.TRANSPARENT);
    }

    public void setForegroundIconColor(Color color, Color outline, double width) {
        this.setForegroundIconColor(color);
        this.foregroundIcon.setStroke((Paint)outline);
        this.foregroundIcon.setStrokeWidth(width);
    }

    public void seBackgroundIconColor(Color color, Color outline, double width) {
        this.setBackgroundIconColor(color);
        this.backgroundIcon.setStroke((Paint)outline);
        this.backgroundIcon.setStrokeWidth(width);
    }

    public void setForegroundIconColorDefault() {
        this.stopForegroundIconColorFadeAnimation();
        this.foregroundIcon.getStyleClass().clear();
        this.foregroundIcon.getStyleClass().add((Object)"icons");
        this.foregroundFadeIcon.setFill((Paint)Color.TRANSPARENT);
    }

    public void setBackgroundIconColorDefault() {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background modification skipped because background icon not set!");
            return;
        }
        this.stopBackgroundIconColorFadeAnimation();
        this.backgroundIcon.getStyleClass().clear();
        this.backgroundIcon.getStyleClass().add((Object)"icons");
        this.backgroundFadeIcon.setFill((Paint)Color.TRANSPARENT);
    }

    public void setForegroundIconColorDefaultInverted() {
        this.setForegroundIconColorDefault();
        this.setForegroundIconColor(this.getForegroundIconColor().invert());
    }

    public void setBackgroundIconColorDefaultInverted() {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background modification skipped because background icon not set!");
            return;
        }
        this.setBackgroundIconColorDefault();
        this.setBackgroundIconColor(this.getBackgroundIconColor().invert());
    }

    public void setForegroundIcon(GlyphIcons icon) {
        this.setForegroundIcon(icon, null);
    }

    public void setBackgroundIcon(GlyphIcons icon) {
        this.setBackgroundIcon(icon, null);
    }

    public void setForegroundIcon(GlyphIcons icon, Color color) {
        Text oldForegroundIcon = this.foregroundIcon;
        Text oldForegroundFadeIcon = this.foregroundFadeIcon;
        this.foregroundIcon = this.createIcon(icon, Layer.FOREGROUND);
        this.foregroundFadeIcon = this.createColorFadeIcon(icon, Layer.FOREGROUND);
        if (color != null) {
            this.setForegroundIconColor(color);
        }
        this.getChildren().replaceAll(node -> {
            if (node.equals(oldForegroundIcon)) {
                return this.foregroundIcon;
            }
            if (node.equals(oldForegroundFadeIcon)) {
                return this.foregroundFadeIcon;
            }
            return node;
        });
    }

    public void setBackgroundIcon(GlyphIcons icon, Color color) {
        Text oldBackgroundIcon = this.backgroundIcon;
        Text oldBackgroundFadeIcon = this.backgroundFadeIcon;
        this.backgroundIcon = this.createIcon(icon, Layer.BACKGROUND);
        this.backgroundFadeIcon = this.createColorFadeIcon(icon, Layer.BACKGROUND);
        if (color != null) {
            this.setBackgroundIconColor(color);
        }
        if (oldBackgroundIcon == null || oldBackgroundFadeIcon == null) {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.backgroundIcon, this.backgroundFadeIcon, this.foregroundIcon, this.foregroundFadeIcon});
            return;
        }
        this.getChildren().replaceAll(node -> {
            if (node.equals(oldBackgroundIcon)) {
                return this.backgroundIcon;
            }
            if (node.equals(oldBackgroundFadeIcon)) {
                return this.backgroundFadeIcon;
            }
            return node;
        });
    }

    public Color getForegroundIconColor() {
        return (Color)this.foregroundIcon.getFill();
    }

    public Color getBackgroundIconColor() {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background color unknown because background icon not set!");
            return Color.TRANSPARENT;
        }
        return (Color)this.backgroundIcon.getFill();
    }

    public double getSize() {
        return this.size;
    }

    private class IconState {
        private Boolean foregroundIconColorFadeAnimationEnabled;
        private Boolean backgroundIconColorFadeAnimationEnabled;
        private Boolean foregroundIconRotateAnimationEnabled;
        private Boolean backgroundIconRotateAnimationEnabled;
        private Color foregroundIconColor;
        private Color backgroundIconColor;

        private IconState() {
        }

        public Boolean isForegroundIconColorFadeAnimationEnabled() {
            return this.foregroundIconColorFadeAnimationEnabled;
        }

        public Boolean isBackgroundIconColorFadeAnimationEnabled() {
            return this.backgroundIconColorFadeAnimationEnabled;
        }

        public Boolean isForegroundIconRotateAnimationEnabled() {
            return this.foregroundIconRotateAnimationEnabled;
        }

        public Boolean isBackgroundIconRotateAnimationEnabled() {
            return this.backgroundIconRotateAnimationEnabled;
        }

        public Color getForegroundIconColor() {
            return this.foregroundIconColor;
        }

        public Color getBackgroundIconColor() {
            return this.backgroundIconColor;
        }

        public void save(SVGIcon icon) {
            assert (icon != null);
            this.foregroundIconColorFadeAnimationEnabled = icon.foregroundColorFadeAnimation != null && icon.foregroundColorFadeAnimation.getStatus().equals((Object)Animation.Status.RUNNING);
            this.backgroundIconColorFadeAnimationEnabled = icon.backgroundIconColorFadeAnimation != null && icon.backgroundIconColorFadeAnimation.getStatus().equals((Object)Animation.Status.RUNNING);
            this.foregroundIconRotateAnimationEnabled = icon.foregroundRotateAnimation != null && icon.foregroundRotateAnimation.getStatus().equals((Object)Animation.Status.RUNNING);
            this.backgroundIconRotateAnimationEnabled = icon.backgroundRotateAnimation != null && icon.backgroundRotateAnimation.getStatus().equals((Object)Animation.Status.RUNNING);
            this.foregroundIconColor = icon.getForegroundIconColor();
            this.backgroundIconColor = icon.getBackgroundIconColor();
        }

        public void restore(SVGIcon icon) {
            if (icon == null) {
                return;
            }
            if (this.foregroundIconColorFadeAnimationEnabled != null) {
                if (this.foregroundIconColorFadeAnimationEnabled.booleanValue()) {
                    SVGIcon.this.startForegroundIconColorFadeAnimation();
                } else {
                    SVGIcon.this.stopForegroundIconColorFadeAnimation();
                }
            }
            if (this.backgroundIconColorFadeAnimationEnabled != null) {
                if (this.backgroundIconColorFadeAnimationEnabled.booleanValue()) {
                    SVGIcon.this.startBackgroundIconColorFadeAnimation();
                } else {
                    SVGIcon.this.stopBackgroundIconColorFadeAnimation();
                }
            }
            if (this.foregroundIconRotateAnimationEnabled != null) {
                if (this.foregroundIconRotateAnimationEnabled.booleanValue()) {
                    SVGIcon.this.startForegroundIconRotateAnimation();
                } else {
                    SVGIcon.this.stopForegroundIconRotateAnimation();
                }
            }
            if (this.backgroundIconRotateAnimationEnabled != null) {
                if (this.backgroundIconRotateAnimationEnabled.booleanValue()) {
                    SVGIcon.this.startBackgroundIconRotateAnimation();
                } else {
                    SVGIcon.this.stopBackgroundIconRotateAnimation();
                }
            }
            if (this.foregroundIconColor != null) {
                icon.setForegroundIconColor(this.foregroundIconColor);
            }
            if (this.backgroundIconColor != null) {
                icon.setBackgroundIconColor(this.backgroundIconColor);
            }
        }
    }

    public static enum Layer {
        FOREGROUND,
        BACKGROUND;

    }
}

