/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller.group;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.openbase.bco.bcozy.controller.ButtonTableCellFactory;
import org.openbase.bco.bcozy.controller.Dialog;
import org.openbase.bco.bcozy.controller.group.UserViewModel;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.util.AuthorizationGroups;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.ExceptionProcessor;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class AuthorizationGroupUsersController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationGroupUsersController.class);
    public BorderPane addUserPane;
    @FXML
    private ComboBox<UserViewModel> availableUsersComboBox;
    @FXML
    private ObserverButton addUserButton;
    @FXML
    private TableView<UserViewModel> userTable;
    @FXML
    private TableColumn<UserViewModel, String> removeUserColumn;
    @FXML
    private TableColumn<UserViewModel, String> usernameColumn;
    private final ObjectProperty<UnitConfigType.UnitConfig> selectedGroup = new SimpleObjectProperty();
    private final ObjectProperty<UserViewModel> selectedUser = new SimpleObjectProperty();

    @FXML
    public void initialize() {
        this.userTable.visibleProperty().bind((ObservableValue)this.selectedGroup.isNotNull());
        this.availableUsersComboBox.visibleProperty().bind((ObservableValue)this.selectedGroup.isNotNull());
        this.addUserButton.visibleProperty().bind((ObservableValue)this.selectedGroup.isNotNull());
        this.availableUsersComboBox.disableProperty().bind((ObservableValue)this.selectedGroup.isNull());
        this.addUserButton.disableProperty().bind((ObservableValue)this.selectedGroup.isNull().or((ObservableBooleanValue)this.selectedUser.isNull()));
        this.usernameColumn.textProperty().bind((ObservableValue)LanguageSelection.getProperty("username"));
        this.addUserButton.setApplyOnNewText(String::toUpperCase);
        this.userTable.widthProperty().addListener((observable, oldValue, newValue) -> this.usernameColumn.setPrefWidth(newValue.doubleValue() - this.removeUserColumn.getWidth() - 2.0));
        this.availableUsersComboBox.prefWidthProperty().bind((ObservableValue)this.addUserPane.widthProperty().multiply(0.5));
        this.removeUserColumn.setCellFactory(new ButtonTableCellFactory((user, cellIndex) -> this.removeFromGroup((UserViewModel)user), () -> new SVGIcon((GlyphIcons)FontAwesomeIcon.TIMES, 16.0, true)));
        this.availableUsersComboBox.setConverter((StringConverter)new StringConverter<UserViewModel>(){

            public String toString(UserViewModel object) {
                return object.getName();
            }

            public UserViewModel fromString(String string) {
                throw new UnsupportedOperationException("fromString not supported for StringConverter<UserViewModel>");
            }
        });
        this.selectedGroup.addListener((observable, oldValue, newValue) -> this.showUserTable((UnitConfigType.UnitConfig)newValue));
        this.selectedUser.bind((ObservableValue)this.availableUsersComboBox.valueProperty());
        this.userTable.setSelectionModel(null);
    }

    private void removeFromGroup(UserViewModel user) {
        UnitConfigType.UnitConfig group = (UnitConfigType.UnitConfig)this.selectedGroup.get();
        if (group == null || user == null) {
            return;
        }
        if (!Dialog.getConfirmation("removeUserFromGroup.confirmation", user.getName(), group.getLabel())) {
            return;
        }
        try {
            AuthorizationGroups.tryRemoveFromGroup((UnitConfigType.UnitConfig)this.selectedGroup.get(), user.getId());
            String successMessage = LanguageSelection.getLocalized("removeUserFromGroup.success", user.getName(), group.getLabel());
            InfoPane.info(successMessage).backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            String failureMessage = LanguageSelection.getLocalized("removeUserFromGroup.failure", user.getName(), group.getLabel(), ExceptionProcessor.getInitialCauseMessage((Throwable)ex));
            InfoPane.info(failureMessage).backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @FXML
    private void addUser() {
        UnitConfigType.UnitConfig group = (UnitConfigType.UnitConfig)this.selectedGroup.get();
        UserViewModel user = (UserViewModel)this.selectedUser.get();
        if (group == null || user == null) {
            return;
        }
        try {
            AuthorizationGroups.tryAddToGroup(group, user.getId());
            String successMessage = LanguageSelection.getLocalized("addUserToGroup.success", user.getName(), group.getLabel());
            InfoPane.info(successMessage).backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            String failureMessage = LanguageSelection.getLocalized("addUserToGroup.failure", user.getName(), group.getLabel(), ExceptionProcessor.getInitialCauseMessage((Throwable)ex));
            InfoPane.info(failureMessage).backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public ObjectProperty<UnitConfigType.UnitConfig> selectedGroupProperty() {
        return this.selectedGroup;
    }

    private void showUserTable(UnitConfigType.UnitConfig unitConfig) {
        if (unitConfig == null) {
            return;
        }
        ObservableList usersInGroup = FXCollections.observableArrayList();
        ObservableList availableUsers = FXCollections.observableArrayList();
        try {
            for (UnitConfigType.UnitConfig userUnitConfig : Registries.getUserRegistry().getUserConfigs()) {
                availableUsers.add((Object)new UserViewModel(userUnitConfig));
            }
            availableUsers.forEach(userViewModel -> {
                if (unitConfig.getAuthorizationGroupConfig().getMemberIdList().contains((Object)userViewModel.getId())) {
                    usersInGroup.add(userViewModel);
                }
            });
            availableUsers.removeAll((Collection)usersInGroup);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.userTable.setItems(usersInGroup);
        this.availableUsersComboBox.setItems(availableUsers);
    }
}

