/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.location.LocationPolygon;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.location.LocationDataType;

public class TilePolygon
extends LocationPolygon {
    private static final Logger LOGGER = LoggerFactory.getLogger(TilePolygon.class);

    public TilePolygon(double ... points) throws InstantiationException {
        super(points);
    }

    @Override
    public void applyDataUpdate(LocationDataType.LocationData unitData) {
        switch (unitData.getPresenceState().getValue()) {
            case PRESENT: {
                this.setCustomColor(Color.GREEN.brighter());
                break;
            }
            case ABSENT: {
                this.setCustomColor(Color.TRANSPARENT);
                break;
            }
            case UNKNOWN: {
                this.setCustomColor(Color.TRANSPARENT);
                break;
            }
            default: {
                ExceptionPrinter.printHistory((Throwable)new EnumNotSupportedException((Enum)unitData.getPresenceState().getValue(), (Object)this), (Logger)LOGGER);
            }
        }
    }

    @Override
    protected void setLocationStyle() {
        this.setMainColor(Color.TRANSPARENT);
        this.setStroke((Paint)Color.WHITE);
        this.setStrokeWidth(1.0);
    }

    @Override
    protected void changeStyleOnSelection(boolean selected) {
        if (selected) {
            this.setMainColor(Constants.TILE_SELECTION);
        } else {
            this.setMainColor(Color.TRANSPARENT);
        }
    }

    @Override
    protected void onColorChange(Color mainColor, Color customColor) {
        if (customColor.equals((Object)Color.TRANSPARENT)) {
            this.setFill((Paint)mainColor);
        } else {
            this.setFill((Paint)mainColor.interpolate(customColor, 0.5));
        }
    }

    public void mouseEntered() {
        this.setStrokeWidth(3.0);
    }

    public void mouseLeft() {
        this.setStrokeWidth(1.0);
    }
}

