/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.openbase.bco.authentication.lib.CachedAuthenticationRemote;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.bcozy.util.AuthorizationGroups;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.user.UserConfigType;

public class UserData {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserData.class);
    private final StringProperty userId = new SimpleStringProperty("");
    private final StringProperty phone = new SimpleStringProperty("");
    private final String originalUserName;
    private final StringProperty userName = new SimpleStringProperty("");
    private final StringProperty mail = new SimpleStringProperty("");
    private final StringProperty firstname = new SimpleStringProperty("");
    private final StringProperty lastName = new SimpleStringProperty("");
    private final BooleanProperty occupant = new SimpleBooleanProperty(false);
    private final BooleanProperty admin = new SimpleBooleanProperty(false);
    private final List<UnitConfigType.UnitConfig> groups = new ArrayList<UnitConfigType.UnitConfig>();

    public static UserData currentUser() throws CouldNotPerformException, InterruptedException, TimeoutException, ExecutionException {
        String userId = SessionManager.getInstance().getUserId();
        UnitConfigType.UnitConfig userConfig = Registries.getUserRegistry().getUserConfigById(userId);
        return new UserData(userConfig);
    }

    public UserData() {
        this.userId.setValue(null);
        this.originalUserName = "";
    }

    public UserData(UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException, InterruptedException, TimeoutException, ExecutionException {
        this.userId.setValue(unitConfig.getId());
        this.originalUserName = unitConfig.getUserConfig().getUserName();
        this.updateValues(unitConfig.getUserConfig());
        Registries.getUserRegistry().addDataObserver((source, data) -> this.updateValues());
    }

    private void updateValues() throws CouldNotPerformException, InterruptedException, TimeoutException, ExecutionException {
        if (!Registries.getUserRegistry().isDataAvailable()) {
            LOGGER.warn("!Registries.getUserRegistry().isDataAvailable()");
            return;
        }
        UserConfigType.UserConfig userConfig = Registries.getUserRegistry().getUserConfigById((String)this.userId.get()).getUserConfig();
        this.updateValues(userConfig);
    }

    private void updateValues(UserConfigType.UserConfig userConfig) throws InterruptedException, CouldNotPerformException, ExecutionException, TimeoutException {
        this.phone.setValue(this.getOrEmptyString(userConfig.getMobilePhoneNumber()));
        this.userName.setValue(this.getOrEmptyString(userConfig.getUserName()));
        this.mail.setValue(this.getOrEmptyString(userConfig.getEmail()));
        this.firstname.setValue(this.getOrEmptyString(userConfig.getFirstName()));
        this.lastName.setValue(this.getOrEmptyString(userConfig.getLastName()));
        this.occupant.setValue(Boolean.valueOf(userConfig.getOccupant()));
        this.admin.setValue((Boolean)CachedAuthenticationRemote.getRemote().isAdmin((String)this.userId.get()).get(2L, TimeUnit.SECONDS));
        if (this.userId.get() != null) {
            this.groups.clear();
            this.groups.addAll(AuthorizationGroups.getGroupsByUser((String)this.userId.get()));
        }
    }

    private String getOrEmptyString(String string) {
        return string != null ? string : "";
    }

    public boolean isUnsaved() {
        return this.getUserId() == null || this.getUserId().isEmpty();
    }

    public String getUserId() {
        return (String)this.userId.get();
    }

    public boolean hasUserId() {
        return this.userId.get() != null && !((String)this.userId.get()).isEmpty();
    }

    public String getPhone() {
        return (String)this.phone.get();
    }

    public StringProperty phoneProperty() {
        return this.phone;
    }

    public String getUserName() {
        return (String)this.userName.get();
    }

    public StringProperty userNameProperty() {
        return this.userName;
    }

    public String getMail() {
        return (String)this.mail.get();
    }

    public StringProperty mailProperty() {
        return this.mail;
    }

    public String getFirstname() {
        return (String)this.firstname.get();
    }

    public StringProperty firstnameProperty() {
        return this.firstname;
    }

    public String getLastName() {
        return (String)this.lastName.get();
    }

    public StringProperty lastNameProperty() {
        return this.lastName;
    }

    public boolean isOccupant() {
        return this.occupant.get();
    }

    public BooleanProperty occupantProperty() {
        return this.occupant;
    }

    public UserConfigType.UserConfig getUserConfig() {
        UserConfigType.UserConfig user = UserConfigType.UserConfig.newBuilder().setUserName(this.getOrEmptyString((String)this.userName.get())).setFirstName(this.getOrEmptyString((String)this.firstname.get())).setLastName(this.getOrEmptyString((String)this.lastName.get())).setEmail(this.getOrEmptyString((String)this.mail.get())).setMobilePhoneNumber(this.getOrEmptyString((String)this.phone.get())).setOccupant(this.occupant.get()).build();
        return user;
    }

    public boolean isAdmin() {
        return this.admin.get();
    }

    public BooleanProperty adminProperty() {
        return this.admin;
    }

    public List<UnitConfigType.UnitConfig> getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserData)) {
            return false;
        }
        UserData that = (UserData)o;
        return Objects.equals(this.userId, that.userId);
    }

    public int hashCode() {
        return Objects.hashCode(this.userId);
    }

    public String getOriginalUserName() {
        return this.originalUserName;
    }
}

