/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public final class ImageViewProvider {
    private static List<ImageView> imageViews = new ArrayList<ImageView>();
    private static ColorAdjust actColor = new ColorAdjust(360.0, 100.0, -100.0, 0.0);

    private ImageViewProvider() {
    }

    public static ImageView createImageView(String imagePath, double size) {
        return ImageViewProvider.init(imagePath, size, size);
    }

    public static ImageView createImageView(String imagePath, double width, double height) {
        return ImageViewProvider.init(imagePath, width, height);
    }

    public static void colorizeIconsToWhite() {
        ImageViewProvider.colorizeIcons(1.0, 1.0, 1.0, 0.0);
    }

    public static void colorizeIconsToBlack() {
        ImageViewProvider.colorizeIcons(1.0, 1.0, -1.0, 0.0);
    }

    public static void colorizeIcons(double hue, double saturation, double brightness, double contrast) {
        actColor = new ColorAdjust(hue, saturation, brightness, contrast);
        for (ImageView imageView : imageViews) {
            imageView.setEffect((Effect)actColor);
            imageView.setSmooth(true);
        }
    }

    private static ImageView init(String imagePath, double width, double height) {
        Image icon = new Image(ImageViewProvider.class.getResourceAsStream(imagePath));
        ImageView imageView = new ImageView(icon);
        imageView.setPreserveRatio(true);
        imageView.setFitHeight(height);
        imageView.setFitWidth(width);
        imageView.setEffect((Effect)actColor);
        imageView.setSmooth(true);
        imageViews.add(imageView);
        return imageView;
    }
}

