/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.controller.UserManagementController;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.mainmenupanes.LoginPane;
import org.openbase.bco.bcozy.view.mainmenupanes.PaneElement;
import org.openbase.bco.bcozy.view.mainmenupanes.TabPaneSelectionModelImpl;

public class UserActionPane
extends PaneElement {
    private final LoginPane loginPane;
    private final PseudoClass tabpaneContentHidden;
    private final TabPane userActionPane;
    private State state;

    public UserActionPane(LoginPane lp, UserManagementController rp) {
        super(true);
        this.loginPane = lp;
        this.loginPane.setState(LoginPane.State.LOGINACTIVE);
        BorderPane root = new BorderPane();
        this.userActionPane = new TabPane();
        TabPaneSelectionModelImpl selectionModel = new TabPaneSelectionModelImpl(this.userActionPane);
        this.userActionPane.setSelectionModel((SingleSelectionModel)selectionModel);
        selectionModel.selectedItemProperty().addListener((ov, oldTab, newTab) -> this.setState(State.OPEN));
        selectionModel.setClickOnSelectedTabListener(tab -> this.toggleState(tab));
        HBox hbox = new HBox();
        AnchorPane anchor = new AnchorPane();
        anchor.getChildren().addAll((Object[])new Node[]{this.userActionPane, hbox});
        anchor.getStyleClass().addAll((Object[])new String[]{"bg-white"});
        AnchorPane.setTopAnchor((Node)hbox, (Double)3.0);
        AnchorPane.setRightAnchor((Node)hbox, (Double)5.0);
        AnchorPane.setTopAnchor((Node)this.userActionPane, (Double)1.0);
        AnchorPane.setRightAnchor((Node)this.userActionPane, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)this.userActionPane, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)this.userActionPane, (Double)10.0);
        Tab loginTab = this.createTab((Pane)this.loginPane, (GlyphIcons)MaterialDesignIcon.LOGIN);
        loginTab.getContent().maxHeight(100.0);
        this.userActionPane.getTabs().addAll((Object[])new Tab[]{loginTab});
        this.userActionPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tabpaneContentHidden = PseudoClass.getPseudoClass((String)"tabcontenthidden");
        root.setCenter((Node)anchor);
        this.setState(State.CLOSED);
        this.getChildren().addAll((Object[])new Node[]{root});
    }

    private Tab createTab(Pane pane, GlyphIcons icon) {
        Tab tab = new Tab();
        SVGIcon svgIcon = new SVGIcon(icon, 16.0, true);
        tab.setGraphic((Node)svgIcon);
        tab.setContent((Node)pane);
        pane.getStyleClass().add((Object)"tab-content-area");
        tab.getStyleClass().add((Object)"tab");
        return tab;
    }

    @Override
    public Node getStatusIcon() {
        VBox statusIcons = new VBox(new Node[]{this.loginPane.getStatusIcon()});
        statusIcons.setAlignment(Pos.CENTER);
        statusIcons.setSpacing(20.0);
        return statusIcons;
    }

    public void toggleState(Tab clickedTab) {
        if (clickedTab.isDisabled()) {
            this.setState(State.CLOSED);
            return;
        }
        if (this.state == State.OPEN) {
            this.setState(State.CLOSED);
        } else {
            this.setState(State.OPEN);
        }
    }

    public void setState(State state) {
        this.state = state;
        this.userActionPane.pseudoClassStateChanged(this.tabpaneContentHidden, state.isActive());
        this.requestLayout();
    }

    public static enum State {
        OPEN(false, new SVGIcon((GlyphIcons)FontAwesomeIcon.CARET_UP, 16.0, true)),
        CLOSED(true, new SVGIcon((GlyphIcons)FontAwesomeIcon.CARET_DOWN, 16.0, true));

        private final boolean active;
        private final SVGIcon icon;

        private State(boolean active, SVGIcon icon) {
            this.active = active;
            this.icon = icon;
        }

        public boolean isActive() {
            return this.active;
        }

        public SVGIcon getIcon() {
            return this.icon;
        }
    }
}

