/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.CustomTextField;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.bcozy.controller.PasswordChangeController;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.model.UserData;
import org.openbase.bco.bcozy.util.Language;
import org.openbase.bco.bcozy.util.Languages;
import org.openbase.bco.bcozy.util.ThemeManager;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.visual.javafx.geometry.svg.SVGGlyphIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class UserSettingsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserSettingsController.class);
    public Pane changePassword;
    public PasswordChangeController changePasswordController;
    @FXML
    private CustomTextField changeUsername;
    @FXML
    private CustomTextField changeFirstname;
    @FXML
    private CustomTextField changeLastname;
    @FXML
    private CustomTextField changeMail;
    @FXML
    private CustomTextField changePhone;
    @FXML
    private VBox root;
    @FXML
    private ChoiceBox<String> themeChoice;
    @FXML
    private ChoiceBox<Language> languageChoice;
    @FXML
    private TitledPane changePasswordPane;
    private ObservableList<String> availableThemes;
    private ObservableList<Language> availableLanguages;

    @FXML
    public void initialize() {
        SessionManager.getInstance().addLoginObserver((o, b) -> {
            LOGGER.warn("isLoggedIn is " + b);
            if (b != null) {
                this.onLogin();
            }
        });
        this.initEditableFields(this.changeUsername, this.changeFirstname, this.changeLastname, this.changeMail, this.changePhone);
        this.initializeLanguages();
        ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        this.availableThemes = FXCollections.observableArrayList();
        for (String theme : ThemeManager.getInstance().getThemeList()) {
            this.availableThemes.add((Object)languageBundle.getString(theme));
        }
        this.themeChoice.setItems(this.availableThemes);
        this.changePasswordPane.setExpanded(false);
    }

    private void initializeLanguages() {
        this.availableLanguages = FXCollections.observableList(Languages.getInstance().get());
        this.languageChoice.setItems(this.availableLanguages);
        this.languageChoice.setConverter((StringConverter)new StringConverter<Language>(){

            public String toString(Language object) {
                return object.getName();
            }

            public Language fromString(String string) {
                return Languages.getInstance().get(string);
            }
        });
        this.languageChoice.getSelectionModel().select((Object)Languages.getInstance().get(Locale.getDefault()));
        this.languageChoice.getSelectionModel().selectedItemProperty().addListener((observable, oldLocale, newLocale) -> {
            if (newLocale != null) {
                LanguageSelection.getInstance().setSelectedLocale(newLocale.getLocale());
            }
        });
    }

    private void onLogin() throws InterruptedException {
        LOGGER.warn("UserID is " + SessionManager.getInstance().getUserId());
        try {
            UserData userData = UserData.currentUser();
            this.changeUsername.textProperty().bindBidirectional((Property)userData.userNameProperty());
            this.changeFirstname.textProperty().bindBidirectional((Property)userData.firstnameProperty());
            this.changeLastname.textProperty().bindBidirectional((Property)userData.lastNameProperty());
            this.changeMail.textProperty().bindBidirectional((Property)userData.mailProperty());
            this.changePhone.textProperty().bindBidirectional((Property)userData.phoneProperty());
        }
        catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
    }

    private void initEditableFields(CustomTextField ... fields) {
        for (CustomTextField field : fields) {
            Button editButton = new Button("");
            editButton.setGraphic((Node)new SVGGlyphIcon((GlyphIcons)FontAwesomeIcon.PENCIL, 16.0, true));
            editButton.setOnAction(a -> {
                if (field.isEditable()) {
                    try {
                        this.saveUserSettings();
                        field.setEditable(false);
                        editButton.setGraphic((Node)new SVGGlyphIcon((GlyphIcons)FontAwesomeIcon.PENCIL, 16.0, true));
                    }
                    catch (InterruptedException ex) {
                        ExceptionPrinter.printHistory((String)"Could not save user settings!", (Throwable)ex, (Logger)LOGGER);
                        Thread.currentThread().interrupt();
                    }
                } else {
                    field.setEditable(true);
                    editButton.setGraphic((Node)new SVGGlyphIcon((GlyphIcons)FontAwesomeIcon.FLOPPY_ALT, 16.0, true));
                }
            });
            field.setEditable(false);
            field.setRight((Node)editButton);
        }
    }

    private void saveUserSettings() throws InterruptedException {
        try {
            UnitConfigType.UnitConfig.Builder newUserConfig = Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).toBuilder();
            newUserConfig.getUserConfigBuilder().setUserName(this.changeUsername.getText()).setFirstName(this.changeFirstname.getText()).setLastName(this.changeLastname.getText()).setEmail(this.changeMail.getText()).setMobilePhoneNumber(this.changePhone.getText());
            Registries.getUserRegistry().updateUserConfig(newUserConfig.build());
            this.showSuccessMessage();
        }
        catch (CouldNotPerformException ex) {
            this.showErrorMessage();
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
    }

    private void showSuccessMessage() {
        InfoPane.info("saveSuccess").backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
    }

    private void showErrorMessage() {
        InfoPane.info("saveError").backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
    }

    public ChoiceBox<String> getThemeChoice() {
        return this.themeChoice;
    }

    public ChoiceBox<Language> getLanguageChoice() {
        return this.languageChoice;
    }

    public ObservableList<String> getAvailableThemes() {
        return this.availableThemes;
    }

    public ObservableList<Language> getAvailableLanguages() {
        return this.availableLanguages;
    }

    public VBox getRoot() {
        return this.root;
    }
}

