/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.permissions.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import org.openbase.bco.bcozy.permissions.UnitPermissionController;
import org.openbase.bco.bcozy.permissions.model.GroupPermissions;
import org.openbase.bco.bcozy.permissions.model.OtherPermissions;
import org.openbase.bco.bcozy.permissions.model.OwnerPermissions;
import org.openbase.bco.bcozy.permissions.model.PermissionsService;
import org.openbase.bco.bcozy.util.AuthorizationGroups;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.authentication.PermissionConfigType;
import rst.domotic.authentication.PermissionType;
import rst.domotic.unit.UnitConfigType;

public final class PermissionsServiceImpl
implements PermissionsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitPermissionController.class);
    public static final PermissionsServiceImpl INSTANCE = new PermissionsServiceImpl();
    private final ObservableList<UnitConfigType.UnitConfig> groups = AuthorizationGroups.getAuthorizationGroups();
    private final List<UnitConfigType.UnitConfig> cachedUnits = new ArrayList<UnitConfigType.UnitConfig>();

    public PermissionsServiceImpl() {
        this.fillCache();
    }

    private void fillCache() {
        try {
            if (Registries.getUnitRegistry().isDataAvailable()) {
                this.setCachedUnits(Registries.getUnitRegistry().getUnitConfigs());
            }
            Registries.getUnitRegistry().addDataObserver((source, data) -> this.setCachedUnits(Registries.getUnitRegistry().getUnitConfigs()));
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            Thread.currentThread().interrupt();
        }
    }

    private void setCachedUnits(List<UnitConfigType.UnitConfig> units) {
        this.cachedUnits.clear();
        this.cachedUnits.addAll(units);
    }

    @Override
    public OwnerPermissions getOwner(String selectedUnitId) throws CouldNotPerformException, InterruptedException {
        if (selectedUnitId == null) {
            return null;
        }
        UnitConfigType.UnitConfig unit = this.findUnitConfigById(selectedUnitId);
        String currentOwnerId = unit.getPermissionConfig().getOwnerId();
        List users = Registries.getUserRegistry().getUserConfigs();
        OwnerPermissions.Owner currentOwner = OwnerPermissions.NULL_OWNER;
        ArrayList<OwnerPermissions.Owner> possibleOwners = new ArrayList<OwnerPermissions.Owner>();
        possibleOwners.add(OwnerPermissions.NULL_OWNER);
        for (UnitConfigType.UnitConfig user : users) {
            boolean isCurrentOwner = Objects.equals(user.getId(), currentOwnerId);
            OwnerPermissions.Owner model = new OwnerPermissions.Owner(user.getId(), user.getUserConfig().getUserName());
            if (isCurrentOwner) {
                currentOwner = model;
            }
            possibleOwners.add(model);
        }
        OwnerPermissions ownerPermissions = new OwnerPermissions(currentOwner, possibleOwners, unit.getPermissionConfig().getOwnerPermission().getRead(), unit.getPermissionConfig().getOwnerPermission().getWrite(), unit.getPermissionConfig().getOwnerPermission().getAccess());
        return ownerPermissions;
    }

    @Override
    public List<GroupPermissions> getUnitPermissions(String selectedUnitId) throws CouldNotPerformException, InterruptedException {
        if (selectedUnitId == null) {
            return Collections.emptyList();
        }
        UnitConfigType.UnitConfig unit = this.findUnitConfigById(selectedUnitId);
        ArrayList<GroupPermissions> groupPermissions = new ArrayList<GroupPermissions>();
        for (UnitConfigType.UnitConfig group : this.groups) {
            Optional<PermissionType.Permission> permission = this.permissionEntryForGroup(unit, group.getId()).map(PermissionConfigType.PermissionConfig.MapFieldEntry::getPermission);
            boolean read = permission.map(PermissionType.Permission::getRead).orElse(false);
            boolean write = permission.map(PermissionType.Permission::getWrite).orElse(false);
            boolean access = permission.map(PermissionType.Permission::getAccess).orElse(false);
            GroupPermissions model = new GroupPermissions(group.getId(), group.getLabel(), read, write, access);
            groupPermissions.add(model);
        }
        return groupPermissions;
    }

    @Override
    public OtherPermissions getOtherPermissions(String selectedUnitId) throws CouldNotPerformException, InterruptedException {
        if (selectedUnitId == null) {
            return null;
        }
        UnitConfigType.UnitConfig unitConfig = this.findUnitConfigById(selectedUnitId);
        return new OtherPermissions(unitConfig.getPermissionConfig().getOtherPermission().getRead(), unitConfig.getPermissionConfig().getOtherPermission().getWrite(), unitConfig.getPermissionConfig().getOtherPermission().getAccess());
    }

    @Override
    public void save(@Nonnull String selectedUnitId, List<GroupPermissions> permissions, @Nonnull OwnerPermissions owner, OtherPermissions other) throws CouldNotPerformException, InterruptedException, ExecutionException {
        boolean changed = false;
        UnitConfigType.UnitConfig unitConfig = this.findUnitConfigById(selectedUnitId);
        if (owner.changed()) {
            changed = true;
        }
        if (other.changed()) {
            changed = true;
        }
        ArrayList<PermissionConfigType.PermissionConfig.MapFieldEntry> permissionEntries = new ArrayList<PermissionConfigType.PermissionConfig.MapFieldEntry>(unitConfig.getPermissionConfig().getGroupPermissionList());
        for (GroupPermissions permission : permissions) {
            if (!permission.changed()) continue;
            permissionEntries.removeIf(entry -> permission.getGroupId().equals(entry.getGroupId()));
            permissionEntries.add(this.toEntry(permission));
            changed = true;
        }
        if (changed) {
            this.save(unitConfig, owner, permissionEntries, other);
        }
    }

    private void save(UnitConfigType.UnitConfig unitConfig, OwnerPermissions ownerPermissions, List<PermissionConfigType.PermissionConfig.MapFieldEntry> permissionEntries, OtherPermissions other) throws CouldNotPerformException, InterruptedException, ExecutionException {
        PermissionConfigType.PermissionConfig.Builder permissionConfigBuilder = unitConfig.getPermissionConfig().toBuilder().clearGroupPermission().addAllGroupPermission(permissionEntries).clearOwnerId().clearOtherPermission().setOtherPermission(PermissionType.Permission.newBuilder().setAccess(other.isAccess()).setWrite(other.isWrite()).setRead(other.isRead())).clearOwnerPermission();
        if (ownerPermissions.owner != OwnerPermissions.NULL_OWNER) {
            permissionConfigBuilder = permissionConfigBuilder.setOwnerId(ownerPermissions.owner.getUserId()).setOwnerPermission(PermissionType.Permission.newBuilder().setAccess(ownerPermissions.isAccess()).setWrite(ownerPermissions.isWrite()).setRead(ownerPermissions.isRead()));
        }
        UnitConfigType.UnitConfig newUnitConfig = unitConfig.toBuilder().clearPermissionConfig().mergePermissionConfig(permissionConfigBuilder.build()).build();
        UnitConfigType.UnitConfig saved = (UnitConfigType.UnitConfig)Registries.getUnitRegistry().updateUnitConfig(newUnitConfig).get();
    }

    private PermissionConfigType.PermissionConfig.MapFieldEntry toEntry(GroupPermissions groupPermissions) {
        return PermissionConfigType.PermissionConfig.MapFieldEntry.newBuilder().setGroupId(groupPermissions.getGroupId()).setPermission(PermissionType.Permission.newBuilder().setAccess(groupPermissions.isAccess()).setWrite(groupPermissions.isWrite()).setRead(groupPermissions.isRead()).build()).build();
    }

    private UnitConfigType.UnitConfig findUnitConfigById(String id) throws CouldNotPerformException, InterruptedException {
        UnitConfigType.UnitConfig unit = this.cachedUnits.stream().filter(unitConfig -> unitConfig.getId().equals(id)).findAny().orElse(null);
        return unit;
    }

    private Optional<PermissionConfigType.PermissionConfig.MapFieldEntry> permissionEntryForGroup(UnitConfigType.UnitConfig unit, String groupId) {
        for (PermissionConfigType.PermissionConfig.MapFieldEntry entry : unit.getPermissionConfig().getGroupPermissionList()) {
            if (!entry.getGroupId().equals(groupId)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }
}

