/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openbase.bco.bcozy.util.Language;
import org.openbase.bco.bcozy.util.LanguageLoader;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleLanguagesDetector
implements LanguageLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleLanguagesDetector.class);
    private static final String BUNDLE_FOLDER = "languages";

    @Override
    public List<Language> getLanguages() {
        List<Locale> bundles = this.getLocalesFromBundles();
        return bundles.stream().map(Language::new).collect(Collectors.toList());
    }

    private List<Locale> getLocalesFromBundles() {
        List<String> matches = this.getFileMatches();
        ArrayList<Locale> locales = new ArrayList<Locale>(matches.size());
        for (String match : matches) {
            if (match.contains("_")) {
                locales.add(new Locale(match.split("_")[0], match.split("_")[1]));
                continue;
            }
            locales.add(new Locale(match));
        }
        return locales;
    }

    @Nonnull
    private List<String> getFileMatches() {
        LinkedList<String> matches = new LinkedList<String>();
        Pattern pattern = Pattern.compile("languages_(\\w+[_\\w+])\\.properties");
        List<String> files = this.getResourceFolderFiles(BUNDLE_FOLDER);
        if (files.isEmpty()) {
            files.addAll(this.getResourceFolderFilesWithStream(BUNDLE_FOLDER));
        }
        for (String file : files) {
            Matcher matcher = pattern.matcher(file);
            if (!matcher.find()) continue;
            matches.add(matcher.group(1));
        }
        return matches;
    }

    @Nonnull
    private List<String> getResourceFolderFiles(String folder) {
        ClassLoader loader = this.getClass().getClassLoader();
        URL url = loader.getResource(folder);
        File[] files = Optional.ofNullable(url).map(URL::getPath).map(File::new).map(File::listFiles).orElse(new File[0]);
        ArrayList<String> names = new ArrayList<String>();
        for (File file : files) {
            names.add(file.getName());
        }
        return names;
    }

    private List<String> getResourceFolderFilesWithStream(String folder) {
        ArrayList<String> filenames = new ArrayList<String>();
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(folder);
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String resource = br.readLine();
            while (resource != null) {
                filenames.add(resource);
                resource = br.readLine();
            }
        }
        catch (IOException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        return filenames;
    }
}

