/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.util;

import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Scene;
import org.openbase.bco.bcozy.BCozy;
import org.openbase.bco.bcozy.util.ThemeLoader;

public class ThemeManager {
    public static boolean darkTheme = false;
    public SimpleStringProperty themeName = new SimpleStringProperty();
    private static ThemeManager instance = new ThemeManager();
    private List<String> themeList = ThemeLoader.loadThemes();

    private ThemeManager() {
        this.themeName.addListener((observable, oldValue, newValue) -> this.applyTheme());
    }

    public static ThemeManager getInstance() {
        return instance;
    }

    public List<String> getThemeList() {
        return this.themeList;
    }

    public void changeTheme(String themeName) {
        this.themeName.setValue(themeName);
    }

    private void applyTheme() {
        if (BCozy.primaryStage != null && BCozy.primaryStage.getScene() != null) {
            this.applyTheme(BCozy.primaryStage.getScene());
        }
    }

    public void applyTheme(Scene scene) {
        if (BCozy.primaryStage != null && BCozy.primaryStage.getScene() != null) {
            scene.getStylesheets().clear();
            scene.getStylesheets().addAll((Object[])new String[]{"/css/skin.css", ThemeLoader.getCssUri(this.themeName.getValue())});
            darkTheme = this.themeName.getValue().toLowerCase().contains("dark");
        }
    }

    public static boolean isDarkThemeSelected() {
        return darkTheme;
    }

    public void loadDefaultTheme() {
        this.themeName.setValue(this.themeList.get(0));
    }
}

