/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import com.jfoenix.controls.JFXSpinner;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.jul.exception.NotAvailableException;

public class LoadingPane
extends BorderPane {
    private static LoadingPane instance;
    private final VBox centerPane;
    private final ObserverLabel textLabel;
    private final JFXSpinner progressSpinner;

    public LoadingPane(double height, double width) {
        this.setPrefSize(width, height);
        this.getStyleClass().add((Object)"loading-pane");
        this.textLabel = new ObserverLabel("initRemotes");
        this.textLabel.getStyleClass().clear();
        this.textLabel.getStyleClass().add((Object)"loading-pane");
        this.progressSpinner = new JFXSpinner();
        this.centerPane = new VBox(10.0);
        this.centerPane.setAlignment(Pos.CENTER);
        this.centerPane.getChildren().addAll((Object[])new Node[]{this.progressSpinner, this.textLabel});
        this.setCenter((Node)this.centerPane);
        instance = this;
    }

    public static LoadingPane getInstance() throws NotAvailableException {
        if (instance == null) {
            throw new NotAvailableException(LoadingPane.class);
        }
        return instance;
    }

    public void info(String identifier) {
        assert (identifier != null);
        Platform.runLater(() -> {
            this.textLabel.setStyle("");
            this.textLabel.setIdentifier(identifier);
        });
    }

    public void confirmation(String identifier) {
        assert (identifier != null);
        Platform.runLater(() -> {
            this.textLabel.setStyle("-fx-text-fill: green;");
            this.textLabel.setIdentifier(identifier);
        });
    }

    public void warn(String identifier) {
        assert (identifier != null);
        Platform.runLater(() -> {
            this.textLabel.setStyle("-fx-text-fill: orange;");
            this.textLabel.setIdentifier(identifier);
        });
    }

    public void error(String identifier) {
        assert (identifier != null);
        Platform.runLater(() -> {
            this.textLabel.setStyle("-fx-text-fill: red;");
            this.textLabel.setIdentifier(identifier);
        });
    }
}

