/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.HiddenSidesPane;
import org.controlsfx.control.textfield.CustomTextField;
import org.openbase.bco.bcozy.view.mainmenupanes.PaneElement;
import org.openbase.bco.bcozy.view.mainmenupanes.UserPane;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.visual.javafx.geometry.svg.SVGGlyphIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.registry.UserRegistryDataType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.user.UserConfigType;

public class AvailableUsersPane
extends PaneElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvailableUsersPane.class);
    private final BorderPane statusIcon;
    private final VBox userPanes;
    private final CustomTextField searchField;
    private final HiddenSidesPane hiddenSidesPane;
    private Predicate<UserConfigType.UserConfig> userPredicate = u -> true;

    public AvailableUsersPane() {
        this.searchField = new CustomTextField();
        this.searchField.setRight((Node)new SVGGlyphIcon((GlyphIcons)FontAwesomeIcon.SEARCH, 16.0, true));
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> this.search((String)newValue));
        this.userPanes = new VBox(10.0);
        this.statusIcon = new BorderPane((Node)new SVGGlyphIcon(MaterialDesignIcon.ACCOUNT_CIRCLE, 42.0, true));
        ScrollPane verticalScrollPane = new ScrollPane();
        verticalScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        verticalScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.setOrientation(Orientation.VERTICAL);
        this.hiddenSidesPane = new HiddenSidesPane();
        this.hiddenSidesPane.setContent((Node)verticalScrollPane);
        this.hiddenSidesPane.setRight((Node)scrollBar);
        scrollBar.maxProperty().bind((ObservableValue)verticalScrollPane.vmaxProperty());
        scrollBar.minProperty().bind((ObservableValue)verticalScrollPane.vminProperty());
        verticalScrollPane.setContent((Node)this.userPanes);
        verticalScrollPane.setFitToWidth(true);
        this.enableSearchField(false);
        this.hoverProperty().addListener((observable, oldValue, newValue) -> this.enableSearchField((boolean)newValue));
    }

    private void enableSearchField(boolean enable) {
        if (enable) {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.searchField, this.hiddenSidesPane});
        } else {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.hiddenSidesPane});
        }
    }

    private void search(String text) {
        if (text == null || text.isEmpty()) {
            this.userPredicate = user -> true;
        }
        this.userPredicate = user -> this.containsIgnoreCase(user.getFirstName(), text) || this.containsIgnoreCase(user.getLastName(), text) || this.containsIgnoreCase(user.getUserName(), text);
        Platform.runLater(() -> this.updateDynamicComponents());
    }

    boolean containsIgnoreCase(String text, String toFind) {
        return text.toLowerCase().contains(toFind.toLowerCase());
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            Registries.getUserRegistry().addDataObserver((Observer)new Observer<UserRegistryDataType.UserRegistryData>(){

                public void update(Observable<UserRegistryDataType.UserRegistryData> source, UserRegistryDataType.UserRegistryData data) throws Exception {
                    Platform.runLater(() -> AvailableUsersPane.this.updateDynamicComponents());
                }
            });
            Platform.runLater(() -> this.updateDynamicComponents());
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void updateDynamicComponents() {
        try {
            if (!Registries.getUserRegistry().isDataAvailable()) {
                return;
            }
            new ArrayList<Node>((Collection<Node>)this.userPanes.getChildren()).forEach(userPane -> {
                ((UserPane)((Object)userPane)).shutdown();
                this.userPanes.getChildren().remove(userPane);
            });
            for (UnitConfigType.UnitConfig userUnitConfig : Registries.getUserRegistry().getUserConfigs()) {
                if (!this.userPredicate.test(userUnitConfig.getUserConfig())) continue;
                UserPane userPane2 = new UserPane();
                userPane2.init(userUnitConfig);
                this.userPanes.getChildren().add((Object)userPane2);
            }
        }
        catch (InterruptedException | MissingResourceException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException(ex), (Logger)LOGGER);
        }
    }

    @Override
    public Node getStatusIcon() {
        return this.statusIcon;
    }
}

