/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.io.IOException;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.bcozy.controller.InitialPasswordChangeController;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.bcozy.view.mainmenupanes.PaneElement;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.visual.javafx.geometry.svg.SVGGlyphIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginPane
extends PaneElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginPane.class);
    private static final String INITIAL_PASSWORD = "admin";
    private final ObserverButton loginBtn;
    private final ObserverButton logoutBtn;
    private final TextField nameTxt;
    private final PasswordField passwordField;
    private final ObserverLabel inputWrongLbl;
    private final Label loggedInUserLbl;
    private final VBox loginLayout;
    private final VBox logoutLayout;
    private final ObserverLabel nameLbl = new ObserverLabel("username");
    private final ObserverLabel pwLbl;
    private final VBox statusIcon;

    public LoginPane() {
        this.nameLbl.setAlignment(Pos.BOTTOM_LEFT);
        this.nameTxt = new TextField();
        this.pwLbl = new ObserverLabel("password");
        this.passwordField = new PasswordField();
        this.inputWrongLbl = new ObserverLabel("inputWrong");
        this.inputWrongLbl.setAlignment(Pos.TOP_LEFT);
        this.loginBtn = new ObserverButton("login");
        HBox rightAlignLoginButton = new HBox(new Node[]{this.loginBtn});
        rightAlignLoginButton.setAlignment(Pos.CENTER_RIGHT);
        this.loginLayout = new VBox(10.0);
        BorderPane loginFirstLineLayout = new BorderPane();
        loginFirstLineLayout.setLeft((Node)this.nameLbl);
        this.loginLayout.getStyleClass().clear();
        this.loginLayout.setAlignment(Pos.BOTTOM_LEFT);
        this.loginLayout.getChildren().addAll((Object[])new Node[]{loginFirstLineLayout, this.nameTxt, this.pwLbl, this.passwordField, rightAlignLoginButton});
        this.logoutLayout = new VBox(10.0);
        SVGGlyphIcon loggedInUserIcon = new SVGGlyphIcon(MaterialDesignIcon.ACCOUNT_CIRCLE, 32.0, true);
        this.loggedInUserLbl = new Label();
        this.logoutBtn = new ObserverButton("logout");
        HBox rightAlignLogoutButton = new HBox(new Node[]{this.logoutBtn});
        rightAlignLogoutButton.setAlignment(Pos.CENTER_RIGHT);
        this.logoutLayout.getStyleClass().clear();
        this.logoutLayout.setAlignment(Pos.TOP_CENTER);
        this.logoutLayout.getChildren().addAll((Object[])new Node[]{loggedInUserIcon, this.loggedInUserLbl, rightAlignLogoutButton});
        this.nameLbl.getStyleClass().clear();
        this.nameLbl.getStyleClass().add((Object)"small-label");
        this.inputWrongLbl.getStyleClass().clear();
        this.inputWrongLbl.getStyleClass().add((Object)"wrong-input-indicator");
        this.pwLbl.getStyleClass().clear();
        this.pwLbl.getStyleClass().add((Object)"small-label");
        this.loginBtn.getStyleClass().clear();
        this.loginBtn.getStyleClass().add((Object)"transparent-button");
        this.logoutBtn.getStyleClass().clear();
        this.logoutBtn.getStyleClass().add((Object)"transparent-button");
        this.setPrefHeight(100.0);
        this.setMaxHeight(100.0);
        this.statusIcon = new VBox(new Node[]{new SVGGlyphIcon(MaterialDesignIcon.LOGIN, 42.0, true)});
        this.setState(State.LOGINACTIVE);
        this.getLoginBtn().setOnAction(event -> this.loginUser());
        this.getLogoutBtn().setOnAction(event -> this.resetLogin());
        this.getPasswordField().setOnAction(event -> this.loginUser());
        this.getNameTxt().setOnAction(event -> this.loginUser());
        this.getNameTxt().setOnKeyTyped(event -> this.resetWrongInput());
        this.getPasswordField().setOnKeyTyped(event -> this.resetWrongInput());
    }

    public ObserverButton getLoginBtn() {
        return this.loginBtn;
    }

    public TextField getNameTxt() {
        return this.nameTxt;
    }

    public PasswordField getPasswordField() {
        return this.passwordField;
    }

    public ObserverButton getLogoutBtn() {
        return this.logoutBtn;
    }

    public ObserverLabel getInputWrongLbl() {
        return this.inputWrongLbl;
    }

    public Label getLoggedInUserLbl() {
        return this.loggedInUserLbl;
    }

    public ObserverLabel getPwLbl() {
        return this.pwLbl;
    }

    public ObserverLabel getNameLbl() {
        return this.nameLbl;
    }

    public void indicateUserOrPasswordWrong() {
        if (!this.loginLayout.getChildren().contains((Object)this.inputWrongLbl)) {
            this.passwordField.getStyleClass().add((Object)"password-field-wrong");
            this.nameTxt.getStyleClass().add((Object)"text-field-wrong");
            this.loginLayout.getChildren().add(this.loginLayout.getChildren().size() - 1, (Object)this.inputWrongLbl);
        }
    }

    public void resetUserOrPasswordWrong() {
        this.passwordField.getStyleClass().clear();
        this.nameTxt.getStyleClass().clear();
        this.passwordField.getStyleClass().add((Object)"password-field");
        this.nameTxt.getStyleClass().add((Object)"text-field");
        if (this.loginLayout.getChildren().contains((Object)this.inputWrongLbl)) {
            this.loginLayout.getChildren().remove((Object)this.inputWrongLbl);
        }
    }

    @Override
    public Node getStatusIcon() {
        return this.statusIcon;
    }

    public void setState(State state) {
        switch (state) {
            case LOGINACTIVE: {
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.loginLayout});
                this.statusIcon.getChildren().clear();
                this.statusIcon.getChildren().addAll((Object[])new Node[]{new SVGGlyphIcon(MaterialDesignIcon.LOGIN, 42.0, true)});
                break;
            }
            case LOGOUT: {
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.logoutLayout});
                this.statusIcon.getChildren().clear();
                this.statusIcon.getChildren().addAll((Object[])new Node[]{new SVGGlyphIcon(MaterialDesignIcon.LOGOUT, 42.0, true)});
            }
        }
    }

    private void startLogin() {
        this.setState(State.LOGINACTIVE);
    }

    private void resetWrongInput() {
        if (this.getInputWrongLbl().isVisible()) {
            this.resetUserOrPasswordWrong();
        }
    }

    private void loginUser() {
        GlobalCachedExecutorService.submit(() -> {
            try {
                this.loginUserAsync();
            }
            catch (InterruptedException ex) {
                ExceptionPrinter.printHistory((String)"Could not login!", (Throwable)ex, (Logger)LOGGER);
            }
        });
    }

    private void loginUserAsync() throws InterruptedException {
        SessionManager sessionManager = SessionManager.getInstance();
        try {
            String password = this.getPasswordField().getText();
            sessionManager.login(Registries.getUserRegistry().getUserIdByUserName(this.getNameTxt().getText()), password);
            Platform.runLater(() -> {
                this.resetUserOrPasswordWrong();
                this.getLoggedInUserLbl().setText(this.getNameTxt().getText());
                this.getNameTxt().setText("");
                this.getPasswordField().setText("");
                this.setState(State.LOGOUT);
            });
            if (password.equals(INITIAL_PASSWORD)) {
                this.showChangeInitialPassword();
            }
        }
        catch (CouldNotPerformException ex) {
            Platform.runLater(() -> this.indicateUserOrPasswordWrong());
        }
        catch (OutOfMemoryError error) {
            LOGGER.error(error.getMessage());
        }
    }

    private void showChangeInitialPassword() {
        Platform.runLater(() -> {
            try {
                ((Stage)InitialPasswordChangeController.loadModalStage().getKey()).show();
            }
            catch (IOException ioe) {
                ExceptionPrinter.printHistory((Throwable)ioe, (Logger)LOGGER);
            }
        });
    }

    private void resetLogin() {
        SessionManager.getInstance().logout();
        if (this.getInputWrongLbl().isVisible()) {
            this.resetUserOrPasswordWrong();
        }
        this.getNameTxt().setText("");
        this.getPasswordField().setText("");
        this.getLoggedInUserLbl().setText("");
        this.setState(State.LOGINACTIVE);
    }

    public static enum State {
        LOGINACTIVE,
        LOGOUT;

    }
}

