/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import de.jensd.fx.glyphs.weathericons.WeatherIcon;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.TemperatureSensorRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.unit.dal.TemperatureSensorDataType;

public class TemperatureSensorPane
extends AbstractUnitPane<TemperatureSensorRemote, TemperatureSensorDataType.TemperatureSensorData> {
    public TemperatureSensorPane() {
        super(TemperatureSensorRemote.class, false);
        this.getIcon().setBackgroundIcon((Object)WeatherIcon.THERMOMETER_EXTERIOR);
        this.getIcon().setForegroundIcon((Object)WeatherIcon.THERMOMETER_INTERNAL);
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        try {
            TemperatureStateType.TemperatureState state = ((TemperatureSensorDataType.TemperatureSensorData)((TemperatureSensorRemote)this.getUnitRemote()).getData()).getTemperatureState();
            if (state.getTemperature() != Double.NEGATIVE_INFINITY) {
                if (state.getTemperature() <= 10.0) {
                    this.getIcon().setForegroundIconColorAnimated(Color.BLUE, 1);
                } else if (state.getTemperature() < 25.0) {
                    double redChannel = (state.getTemperature() - 10.0) / 15.0;
                    double blueChannel = 1.0 - (state.getTemperature() - 10.0) / 15.0;
                    this.getIcon().setForegroundIconColor(new Color(redChannel, 0.0, blueChannel, 1.0));
                } else {
                    this.getIcon().setForegroundIconColorAnimated(Color.RED, 1);
                }
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
        }
    }
}

