/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.math.Vec3DDoubleType;

public class UnitShapeTransformer
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitShapeTransformer.class);

    public void start(Stage primaryStage) throws CouldNotPerformException, InterruptedException, ExecutionException {
        final Button resetButton = new Button();
        resetButton.setText("Reset");
        StackPane root = new StackPane();
        root.getChildren().add((Object)resetButton);
        Scene scene = new Scene((Parent)root, 300.0, 250.0);
        primaryStage.setTitle("Unit Shape Transformer");
        primaryStage.setScene(scene);
        primaryStage.show();
        try {
            final UnitConfigType.UnitConfig rootLocationConfig = Registries.getLocationRegistry((boolean)true).getRootLocationConfig();
            final UnitRemote location = Units.getUnit((UnitConfigType.UnitConfig)rootLocationConfig, (boolean)true, (Class)Units.LOCATION);
            resetButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    try {
                        resetButton.setDisable(true);
                        Registries.getUnitRegistry((boolean)true).updateUnitConfig(rootLocationConfig).get();
                        resetButton.setDisable(false);
                    }
                    catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((String)"Could not reset unit config", (Throwable)ex, (Logger)LOGGER);
                        resetButton.setDisable(false);
                    }
                }
            });
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    try {
                        double offset = 0.1;
                        switch (event.getCode()) {
                            case UP: {
                                UnitShapeTransformer.this.translateUnitShape(-offset, 0.0, (UnitConfigType.UnitConfig)location.getConfig());
                                break;
                            }
                            case DOWN: {
                                UnitShapeTransformer.this.translateUnitShape(offset, 0.0, (UnitConfigType.UnitConfig)location.getConfig());
                                break;
                            }
                            case LEFT: {
                                UnitShapeTransformer.this.translateUnitShape(0.0, -offset, (UnitConfigType.UnitConfig)location.getConfig());
                                break;
                            }
                            case RIGHT: {
                                UnitShapeTransformer.this.translateUnitShape(0.0, offset, (UnitConfigType.UnitConfig)location.getConfig());
                            }
                        }
                    }
                    catch (InterruptedException | CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((String)"Task could not be performed!", (Throwable)ex, (Logger)LOGGER);
                    }
                }
            });
        }
        catch (Exception ex) {
            ExceptionPrinter.printHistory((String)"Could not init system!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    private void translateUnitShape(double xOffset, double yOffset, UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException, InterruptedException {
        UnitConfigType.UnitConfig.Builder builder = unitConfig.toBuilder();
        builder.getPlacementConfigBuilder().getShapeBuilder().clearFloor().addAllFloor(this.updatePositions(xOffset, yOffset, unitConfig.getPlacementConfig().getShape().getFloorList()));
        builder.getPlacementConfigBuilder().getShapeBuilder().clearCeiling().addAllCeiling(this.updatePositions(xOffset, yOffset, unitConfig.getPlacementConfig().getShape().getCeilingList()));
        try {
            Registries.getUnitRegistry().updateUnitConfig(builder.build()).get();
        }
        catch (ExecutionException ex) {
            throw new CouldNotPerformException("Could not translate unit shape");
        }
    }

    private List<Vec3DDoubleType.Vec3DDouble> updatePositions(double xOffset, double yOffset, List<Vec3DDoubleType.Vec3DDouble> originalPostionList) {
        ArrayList<Vec3DDoubleType.Vec3DDouble> updatedPostionList = new ArrayList<Vec3DDoubleType.Vec3DDouble>();
        for (Vec3DDoubleType.Vec3DDouble position : originalPostionList) {
            updatedPostionList.add(position.toBuilder().setX(position.getX() + xOffset).setY(position.getY() + yOffset).build());
        }
        return updatedPostionList;
    }

    public static void main(String[] args) {
        UnitShapeTransformer.launch((String[])args);
    }
}

