/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.bco.bcozy.view.pane.unit.TitledUnitPaneContainer;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class ContextMenuController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextMenuController.class);
    private final ForegroundPane foregroundPane;
    private final Map<String, TitledUnitPaneContainer> titledPaneMap;

    public ContextMenuController(ForegroundPane foregroundPane, LocationPane backgroundPane) {
        this.foregroundPane = foregroundPane;
        this.titledPaneMap = new HashMap<String, TitledUnitPaneContainer>();
        backgroundPane.addSelectedLocationIdListener((ChangeListener<? super String>)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String location) {
                if (Registries.isDataAvailable()) {
                    try {
                        ContextMenuController.this.setContextMenuUnitPanes(location);
                    }
                    catch (InterruptedException | CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((String)("Units for selected location[" + location + "] could not be loaded."), (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                    }
                } else {
                    LOGGER.warn("Registries not ready yet! Thus no Context Menu will be loaded!");
                }
            }
        });
    }

    public void setContextMenuUnitPanes(String locationID) throws CouldNotPerformException, InterruptedException {
        try {
            TitledUnitPaneContainer titledPaneContainer;
            if ("none".equals(locationID)) {
                throw new CouldNotPerformException("No location is selected.");
            }
            if (this.titledPaneMap.containsKey(locationID)) {
                titledPaneContainer = this.titledPaneMap.get(locationID);
            } else {
                titledPaneContainer = new TitledUnitPaneContainer();
                this.fillTitledPaneContainer(titledPaneContainer, locationID);
            }
            this.foregroundPane.getContextMenu().setTitledPaneContainer(titledPaneContainer);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not set context menu.", (Throwable)ex);
        }
    }

    private void fillTitledPaneContainer(TitledUnitPaneContainer titledPaneContainer, String locationID) throws CouldNotPerformException, InterruptedException {
        try {
            this.titledPaneMap.put(locationID, titledPaneContainer);
            block5: for (Map.Entry nextEntry : ((LocationRemote)Units.getUnit((String)locationID, (boolean)false, (Class)Units.LOCATION)).getUnitMap().entrySet()) {
                if (((List)nextEntry.getValue()).isEmpty()) continue;
                switch ((UnitTemplateType.UnitTemplate.UnitType)nextEntry.getKey()) {
                    case BUTTON: 
                    case DEVICE: 
                    case UNKNOWN: {
                        continue block5;
                    }
                }
                titledPaneContainer.createAndAddNewTitledPane((UnitTemplateType.UnitTemplate.UnitType)nextEntry.getKey(), (List)nextEntry.getValue());
            }
            titledPaneContainer.addDummyPane();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not fill titled pane container.", (Throwable)ex);
        }
    }

    public void clearTitledPaneMap() {
        for (Map.Entry<String, TitledUnitPaneContainer> nextEntry : this.titledPaneMap.entrySet()) {
            nextEntry.getValue().clearTitledPane();
        }
        this.titledPaneMap.clear();
        this.foregroundPane.getContextMenu().clearVerticalScrollPane();
    }

    public void initTitledPaneMap() throws CouldNotPerformException, InterruptedException {
        try {
            for (UnitConfigType.UnitConfig locationUnitConfig : Registries.getLocationRegistry().getLocationConfigs()) {
                String locationID = locationUnitConfig.getId();
                TitledUnitPaneContainer titledPaneContainer = new TitledUnitPaneContainer();
                this.fillTitledPaneContainer(titledPaneContainer, locationID);
            }
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not init initTitledPaneMap!", ex), (Logger)LOGGER);
        }
    }
}

