/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.jfoenix.controls.JFXTreeTableView;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import org.openbase.bco.bcozy.controller.UserManagementController;
import org.openbase.bco.bcozy.controller.UserSettingsController;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.permissions.model.RecursiveUnitConfig;
import org.openbase.bco.bcozy.util.ThemeManager;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.visual.javafx.fxml.FXMLProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsController.class);
    public Accordion adminAccordion;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab settingsTab;
    @FXML
    private Tab permissionTab;
    @FXML
    private JFXTreeTableView<RecursiveUnitConfig> unitsTable;
    @FXML
    private VBox permissionPaneParent;
    private UserSettingsController userSettingsController;

    @Deprecated
    public SettingsController(ForegroundPane foregroudPane) {
    }

    public SettingsController() {
    }

    @FXML
    public void initialize() {
        this.settingsTab.setGraphic((Node)new ObserverLabel("settings"));
        this.permissionTab.setGraphic((Node)new ObserverLabel("permissions"));
        try {
            this.settingsTab.setContent((Node)this.loadUserSettingsPane());
        }
        catch (CouldNotPerformException es) {
            ExceptionPrinter.printHistory((Throwable)es, (Logger)LOGGER);
        }
        try {
            this.permissionTab.setContent((Node)this.loadPermissionPane());
        }
        catch (CouldNotPerformException es) {
            ExceptionPrinter.printHistory((Throwable)es, (Logger)LOGGER);
        }
        this.tabPane.widthProperty().addListener(this::onPaneWidthChange);
        this.onPaneWidthChange(null, null, null);
        this.tabPane.getStyleClass().addAll((Object[])new String[]{"detail-menu"});
        try {
            TitledPane registrationPane = new TitledPane("userManagement", (Node)this.loadRegistrationPane());
            LanguageSelection.addObserverFor("userManagement", arg_0 -> ((TitledPane)registrationPane).setText(arg_0));
            this.adminAccordion.getPanes().add((Object)registrationPane);
        }
        catch (CouldNotPerformException es) {
            ExceptionPrinter.printHistory((Throwable)es, (Logger)LOGGER);
        }
        try {
            TitledPane groupsPane = new TitledPane("usergroups", (Node)this.loadGroupsPane());
            LanguageSelection.addObserverFor("usergroups", arg_0 -> ((TitledPane)groupsPane).setText(arg_0));
            this.adminAccordion.getPanes().add((Object)groupsPane);
        }
        catch (CouldNotPerformException es) {
            ExceptionPrinter.printHistory((Throwable)es, (Logger)LOGGER);
        }
    }

    private Pane loadUserSettingsPane() throws CouldNotPerformException {
        try {
            Pair paneAndControllerPair = FXMLProcessor.loadFxmlPaneAndControllerPair((String)"UserSettingsPane.fxml", UserSettingsController.class, this.getClass());
            this.userSettingsController = (UserSettingsController)paneAndControllerPair.getValue();
            this.userSettingsController.getThemeChoice().setOnAction(event -> this.chooseTheme());
            this.userSettingsController.getThemeChoice().getSelectionModel().select(0);
            return (Pane)paneAndControllerPair.getKey();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Content could not be loaded", (Throwable)ex);
        }
    }

    private <T> void onPaneWidthChange(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        double width = this.tabPane.getWidth();
        double childrenCount = this.settingsTab.getTabPane().getTabs().size();
        this.settingsTab.getTabPane().setTabMinWidth(width / (childrenCount + 1.0));
    }

    public UserSettingsController getUserSettingsController() {
        return this.userSettingsController;
    }

    private void chooseTheme() {
        this.userSettingsController.getThemeChoice().getSelectionModel().selectedIndexProperty().addListener((observableValue, number, number2) -> ThemeManager.getInstance().changeTheme((String)this.userSettingsController.getAvailableThemes().get(number2.intValue())));
    }

    private Pane loadPermissionPane() throws CouldNotPerformException {
        try {
            return (Pane)FXMLProcessor.loadFxmlPaneAndControllerPair((String)"view/permissions/PermissionsPane.fxml", this.getClass()).getKey();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not load permission pane", (Throwable)ex);
        }
    }

    private Pane loadGroupsPane() throws CouldNotPerformException {
        try {
            return (Pane)FXMLProcessor.loadFxmlPaneAndControllerPair((String)"GroupsPane.fxml", this.getClass()).getKey();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not load group pane", (Throwable)ex);
        }
    }

    private Pane loadRegistrationPane() throws CouldNotPerformException {
        try {
            return (Pane)FXMLProcessor.loadFxmlPaneAndControllerPair((String)"Registration.fxml", this.getClass(), clazz -> new UserManagementController()).getKey();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not load registration pane", (Throwable)ex);
        }
    }
}

