/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.jfoenix.controls.JFXCheckBox;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.controlsfx.control.CheckComboBox;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.model.SessionManagerFacade;
import org.openbase.bco.bcozy.model.SessionManagerFacadeImpl;
import org.openbase.bco.bcozy.model.UserData;
import org.openbase.bco.bcozy.util.AuthorizationGroups;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.ExceptionProcessor;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.user.UserConfigType;

public class UserManagementController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManagementController.class);
    private SessionManagerFacade sessionManager = new SessionManagerFacadeImpl();
    @FXML
    private Pane root;
    @FXML
    private PasswordField passwordField;
    @FXML
    private PasswordField repeatPasswordField;
    @FXML
    private TextField username;
    @FXML
    private TextField firstname;
    @FXML
    private TextField lastname;
    @FXML
    private TextField mail;
    @FXML
    private TextField phone;
    @FXML
    private CheckComboBox<UnitConfigType.UnitConfig> usergroupField;
    @FXML
    private ComboBox<UserData> chooseUserBox;
    @FXML
    private JFXCheckBox isAdmin;
    @FXML
    private JFXCheckBox isOccupant;
    @FXML
    private ObserverButton saveBtn;
    @FXML
    public ObserverButton deleteButton;
    @FXML
    private ObserverLabel usernameEmptyLabel;
    @FXML
    private ObserverLabel usernameAlreadyExistsLabel;
    @FXML
    private ObserverLabel firstnameEmptyLabel;
    @FXML
    private ObserverLabel lastnameEmptyLabel;
    @FXML
    private ObserverLabel mailEmptyLabel;
    @FXML
    private ObserverLabel passwordLabel;
    @FXML
    private ObserverLabel repeatPasswordLabel;
    @FXML
    private ObserverLabel passwordEmptyLabel;
    @FXML
    private ObserverLabel passwordsNotEqualLabel;
    private UserData selectedUser;

    public void initialize() {
        ObservableList<UnitConfigType.UnitConfig> groups = AuthorizationGroups.getAuthorizationGroups();
        groups.addListener(c -> this.setGroups(groups));
        this.chooseUserBox.setConverter((StringConverter)new StringConverter<UserData>(){

            public String toString(UserData object) {
                if (object.isUnsaved()) {
                    return LanguageSelection.getLocalized("newUser");
                }
                return object.getUserName();
            }

            public UserData fromString(String string) {
                return UserManagementController.this.chooseUserBox.getItems().stream().filter(userData -> !userData.isUnsaved()).filter(userData -> userData.getUserName().equals(string)).findFirst().orElse(new UserData());
            }
        });
        this.chooseUserBox.valueProperty().addListener((observable, oldValue, newValue) -> this.userSelected((UserData)newValue));
        this.saveBtn.setApplyOnNewText(String::toUpperCase);
        this.deleteButton.setApplyOnNewText(String::toUpperCase);
        this.usergroupField.setConverter(AuthorizationGroups.stringConverter(groups));
        this.usergroupField.prefWidthProperty().bind((ObservableValue)this.root.widthProperty());
        this.usernameEmptyLabel.getStyleClass().remove((Object)"label");
        this.firstnameEmptyLabel.getStyleClass().remove((Object)"label");
        this.lastnameEmptyLabel.getStyleClass().remove((Object)"label");
        this.mailEmptyLabel.getStyleClass().remove((Object)"label");
        this.usernameAlreadyExistsLabel.getStyleClass().remove((Object)"label");
        this.usernameAlreadyExistsLabel.setTranslateY(-10.0);
        try {
            Registries.getUserRegistry().addDataObserver((source, data) -> this.fillUserList());
        }
        catch (NotAvailableException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        SessionManager.getInstance().addLoginObserver((source, data) -> this.fillUserList());
    }

    private void fillUserList() {
        if (Platform.isFxApplicationThread()) {
            this.fillUserListInternal();
        } else {
            Platform.runLater(this::fillUserListInternal);
        }
    }

    private void fillUserListInternal() {
        Toolkit.getToolkit().checkFxUserThread();
        UserData userData = this.selectedUser;
        this.chooseUserBox.getItems().clear();
        this.chooseUserBox.getItems().add((Object)new UserData());
        try {
            if (Registries.getUserRegistry().isDataAvailable()) {
                List users = Registries.getUserRegistry().getUserConfigs();
                for (UnitConfigType.UnitConfig user : users) {
                    this.chooseUserBox.getItems().add((Object)new UserData(user));
                }
            }
        }
        catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.chooseUserBox.getItems().contains((Object)userData)) {
            this.chooseUserBox.getSelectionModel().select((Object)userData);
        } else {
            this.chooseUserBox.getSelectionModel().select(0);
        }
    }

    private void userSelected(UserData selectedUser) {
        if (Platform.isFxApplicationThread()) {
            this.userSelectedInternal(selectedUser);
        } else {
            Platform.runLater(() -> this.userSelectedInternal(selectedUser));
        }
    }

    private void userSelectedInternal(UserData selectedUser) {
        Toolkit.getToolkit().checkFxUserThread();
        this.unbindFields();
        this.resetFields();
        this.resetHints();
        if (selectedUser == null) {
            this.saveBtn.setDisable(true);
            this.deleteButton.setDisable(true);
            this.passwordField.setVisible(false);
            this.repeatPasswordField.setVisible(false);
            this.passwordLabel.setVisible(false);
            this.repeatPasswordLabel.setVisible(false);
            return;
        }
        this.selectedUser = selectedUser;
        this.bindProperty((TextInputControl)this.username, UserData::userNameProperty);
        this.bindProperty((TextInputControl)this.firstname, UserData::firstnameProperty);
        this.bindProperty((TextInputControl)this.lastname, UserData::lastNameProperty);
        this.bindProperty((TextInputControl)this.mail, UserData::mailProperty);
        this.bindProperty((TextInputControl)this.phone, UserData::phoneProperty);
        this.isOccupant.selectedProperty().bindBidirectional((Property)selectedUser.occupantProperty());
        this.isAdmin.selectedProperty().bindBidirectional((Property)selectedUser.adminProperty());
        for (UnitConfigType.UnitConfig unitConfig : this.usergroupField.getItems()) {
            for (UnitConfigType.UnitConfig userGroup : selectedUser.getGroups()) {
                if (!unitConfig.getId().equals(userGroup.getId())) continue;
                this.usergroupField.getCheckModel().check((Object)unitConfig);
            }
        }
        if (selectedUser.isUnsaved()) {
            this.saveBtn.setIdentifier("register");
            this.deleteButton.setDisable(true);
            this.saveBtn.setDisable(false);
            this.passwordField.setVisible(true);
            this.repeatPasswordField.setVisible(true);
            this.passwordLabel.setVisible(true);
            this.repeatPasswordLabel.setVisible(true);
        } else {
            this.saveBtn.setIdentifier("save");
            this.deleteButton.setDisable(false);
            this.saveBtn.setDisable(false);
            this.passwordField.setVisible(false);
            this.repeatPasswordField.setVisible(false);
            this.passwordLabel.setVisible(false);
            this.repeatPasswordLabel.setVisible(false);
        }
    }

    private void unbindFields() {
        if (this.selectedUser == null) {
            return;
        }
        this.unbindProperty((TextInputControl)this.username, UserData::userNameProperty);
        this.unbindProperty((TextInputControl)this.firstname, UserData::firstnameProperty);
        this.unbindProperty((TextInputControl)this.lastname, UserData::lastNameProperty);
        this.unbindProperty((TextInputControl)this.mail, UserData::mailProperty);
        this.unbindProperty((TextInputControl)this.phone, UserData::phoneProperty);
        this.isOccupant.selectedProperty().unbindBidirectional((Property)this.selectedUser.occupantProperty());
        this.isAdmin.selectedProperty().unbindBidirectional((Property)this.selectedUser.adminProperty());
    }

    private void bindProperty(TextInputControl field, Function<UserData, StringProperty> propertySupplier) {
        field.textProperty().bindBidirectional((Property)propertySupplier.apply(this.selectedUser));
    }

    private void unbindProperty(TextInputControl field, Function<UserData, StringProperty> propertySupplier) {
        field.textProperty().unbindBidirectional((Property)propertySupplier.apply(this.selectedUser));
    }

    private void setGroups(ObservableList<UnitConfigType.UnitConfig> groups) {
        Platform.runLater(() -> this.usergroupField.getItems().setAll((Collection)groups));
    }

    @FXML
    private void save() throws InterruptedException {
        if (this.selectedUser.isUnsaved()) {
            this.registerUser();
        } else {
            this.saveUser();
        }
    }

    private void registerUser() throws InterruptedException {
        this.resetHints();
        if (!this.sessionManager.isAdmin()) {
            return;
        }
        if (!this.checkFields()) {
            return;
        }
        try {
            this.sessionManager.verifyPasswords(this.passwordField.getText(), this.repeatPasswordField.getText());
        }
        catch (VerificationFailedException ex) {
            this.passwordField.getStyleClass().add((Object)"password-field-wrong");
            this.repeatPasswordField.getStyleClass().add((Object)"password-field-wrong");
            this.passwordsNotEqualLabel.setVisible(true);
            return;
        }
        ObservableList groups = this.usergroupField.getCheckModel().getCheckedItems();
        this.selectedUser.getUserConfig();
        UserConfigType.UserConfig user = this.selectedUser.getUserConfig();
        try {
            this.sessionManager.registerUser(user, this.passwordField.getText(), this.isAdmin.isSelected(), (List<UnitConfigType.UnitConfig>)groups);
            this.resetFields();
            this.showSuccessMessage();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            this.showErrorMessage((Exception)((Object)ex));
        }
    }

    private boolean checkFields() throws InterruptedException {
        if (this.selectedUser.getUserName().isEmpty()) {
            this.username.getStyleClass().add((Object)"text-field-wrong");
            this.usernameEmptyLabel.setVisible(true);
        }
        if (this.needsUserNameVerifing()) {
            try {
                this.sessionManager.verifyUserName(this.username.getText());
            }
            catch (VerificationFailedException ex) {
                this.username.getStyleClass().add((Object)"text-field-wrong");
                this.usernameAlreadyExistsLabel.setVisible(true);
                return false;
            }
        }
        if (this.firstname.getText().equals("")) {
            this.firstname.getStyleClass().add((Object)"text-field-wrong");
            this.firstnameEmptyLabel.setVisible(true);
            return false;
        }
        if (this.lastname.getText().equals("")) {
            this.lastname.getStyleClass().add((Object)"text-field-wrong");
            this.lastnameEmptyLabel.setVisible(true);
            return false;
        }
        if (this.passwordField.getText().equals("")) {
            this.passwordField.getStyleClass().add((Object)"text-field-wrong");
            this.passwordEmptyLabel.setVisible(true);
            return false;
        }
        try {
            this.sessionManager.verifyPhoneNumber(this.phone.getText());
        }
        catch (VerificationFailedException ex) {
            this.phone.getStyleClass().add((Object)"text-field-wrong");
            return false;
        }
        try {
            this.sessionManager.verifyMailAddress(this.mail.getText());
        }
        catch (VerificationFailedException ex) {
            this.mail.getStyleClass().add((Object)"text-field-wrong");
            this.mailEmptyLabel.setVisible(true);
            return false;
        }
        return true;
    }

    private boolean needsUserNameVerifing() throws InterruptedException {
        return !this.selectedUser.getUserName().equals(this.selectedUser.getOriginalUserName());
    }

    private void saveUser() throws InterruptedException {
        this.resetHints();
        if (!this.sessionManager.isAdmin()) {
            return;
        }
        if (!this.checkFields()) {
            return;
        }
        try {
            ArrayList groups = new ArrayList(this.usergroupField.getCheckModel().getCheckedItems());
            UnitConfigType.UnitConfig unitConfig = Registries.getUserRegistry().getUserConfigById(this.selectedUser.getUserId()).toBuilder().setUserConfig(this.selectedUser.getUserConfig()).build();
            Registries.getUserRegistry().updateUserConfig(unitConfig);
            for (UnitConfigType.UnitConfig config : this.selectedUser.getGroups()) {
                AuthorizationGroups.tryRemoveFromGroup(config, this.selectedUser.getUserId());
            }
            for (UnitConfigType.UnitConfig config : groups) {
                AuthorizationGroups.tryAddToGroup(config, this.selectedUser.getUserId());
            }
            this.showSuccessMessage();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            this.showErrorMessage((Exception)((Object)ex));
        }
    }

    @FXML
    private void delete(ActionEvent actionEvent) {
        new Alert(Alert.AlertType.CONFIRMATION, LanguageSelection.getLocalized("confirmDelete"), new ButtonType[0]).showAndWait().filter(response -> response == ButtonType.OK).ifPresent(response -> {
            try {
                this.deleteUser();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        });
    }

    private void deleteUser() throws InterruptedException {
        try {
            Registries.getUserRegistry().removeUserConfig(Registries.getUnitRegistry().getUnitConfigById(this.selectedUser.getUserId()));
            this.showSuccessMessage("deleteSuccess");
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            this.showErrorMessage((Exception)((Object)ex));
        }
        this.userSelected(null);
    }

    private void resetHints() {
        this.username.getStyleClass().removeAll((Object[])new String[]{"text-field-wrong"});
        this.firstname.getStyleClass().removeAll((Object[])new String[]{"text-field-wrong"});
        this.lastname.getStyleClass().removeAll((Object[])new String[]{"text-field-wrong"});
        this.passwordField.getStyleClass().removeAll((Object[])new String[]{"password-field-wrong"});
        this.repeatPasswordField.getStyleClass().removeAll((Object[])new String[]{"password-field-wrong"});
        this.usernameEmptyLabel.setVisible(false);
        this.firstnameEmptyLabel.setVisible(false);
        this.lastnameEmptyLabel.setVisible(false);
        this.mailEmptyLabel.setVisible(false);
        this.usernameAlreadyExistsLabel.setVisible(false);
        this.passwordsNotEqualLabel.setVisible(false);
        this.passwordEmptyLabel.setVisible(false);
    }

    private void resetFields() {
        this.username.setText("");
        this.firstname.setText("");
        this.lastname.setText("");
        this.mail.setText("");
        this.phone.setText("");
        this.passwordField.setText("");
        this.repeatPasswordField.setText("");
        this.isAdmin.setSelected(false);
        this.usergroupField.getCheckModel().clearChecks();
    }

    private void showSuccessMessage() {
        this.showSuccessMessage("saveSuccess");
    }

    private void showSuccessMessage(String message) {
        InfoPane.info(message).backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
    }

    private void showErrorMessage() {
        InfoPane.info("saveError").backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
    }

    private void showErrorMessage(Exception ex) {
        String message = LanguageSelection.getLocalized("saveErrorWithMessage", ExceptionProcessor.getInitialCauseMessage((Throwable)ex));
        InfoPane.info(message).backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
    }

    public Pane getRoot() {
        return this.root;
    }
}

