/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.model;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.bcozy.model.SessionManagerFacade;
import org.openbase.bco.bcozy.util.AuthorizationGroups;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.VerificationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.user.UserConfigType;

public class SessionManagerFacadeImpl
implements SessionManagerFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionManagerFacadeImpl.class);

    @Override
    public boolean isAdmin() {
        return SessionManager.getInstance().isAdmin();
    }

    @Override
    public void registerUser(UserConfigType.UserConfig user, String plainPassword, boolean asAdmin, List<UnitConfigType.UnitConfig> groups) throws CouldNotPerformException {
        try {
            this.tryRegisterUser(user, plainPassword, asAdmin, groups);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register user!", ex);
        }
    }

    private void tryRegisterUser(UserConfigType.UserConfig user, String plainPassword, boolean asAdmin, List<UnitConfigType.UnitConfig> groups) throws CouldNotPerformException, ExecutionException, InterruptedException, TimeoutException {
        UnitConfigType.UnitConfig unitConfig = this.tryCreateUser(user);
        try {
            SessionManager.getInstance().registerUser(unitConfig.getId(), plainPassword, asAdmin);
        }
        catch (CouldNotPerformException ex) {
            Registries.getUserRegistry().removeUserConfig(unitConfig);
            throw ex;
        }
        try {
            for (UnitConfigType.UnitConfig group : groups) {
                AuthorizationGroups.tryAddToGroup(group, unitConfig.getId());
            }
        }
        catch (InterruptedException | CouldNotPerformException ex) {
            for (UnitConfigType.UnitConfig group : groups) {
                AuthorizationGroups.tryRemoveFromGroup(group, unitConfig.getId());
            }
            SessionManager.getInstance().removeUser(unitConfig.getId());
            Registries.getUserRegistry().removeUserConfig(unitConfig);
            throw ex;
        }
    }

    private UnitConfigType.UnitConfig tryCreateUser(UserConfigType.UserConfig user) throws CouldNotPerformException, InterruptedException, ExecutionException, TimeoutException {
        UnitConfigType.UnitConfig.Builder builder = UnitConfigType.UnitConfig.newBuilder();
        UnitConfigType.UnitConfig unitConfig = builder.setUserConfig(user).setType(UnitTemplateType.UnitTemplate.UnitType.USER).build();
        Future registeredUser = Registries.getUserRegistry().registerUserConfig(unitConfig);
        return (UnitConfigType.UnitConfig)registeredUser.get(5L, TimeUnit.SECONDS);
    }

    @Override
    public void verifyUserName(String username) throws VerificationFailedException, InterruptedException {
        try {
            this.verifyNotEmpty(username, "Username");
            for (UnitConfigType.UnitConfig userUnitConfig : Registries.getUserRegistry().getUserConfigs()) {
                if (!userUnitConfig.getUserConfig().getUserName().equals(username)) continue;
                throw new VerificationFailedException("Username[" + username + "] already in use!");
            }
        }
        catch (CouldNotPerformException ex) {
            LOGGER.warn("Could not verify user name!", (Throwable)ex);
            throw new VerificationFailedException("Could not verify user name!", (Throwable)ex);
        }
    }

    @Override
    public void verifyPasswords(String password, String repeatedPassword) throws VerificationFailedException {
        if (!password.equals(repeatedPassword)) {
            throw new VerificationFailedException("repeated password does not match!");
        }
        this.verifyNotEmpty(password, "Password");
    }

    @Override
    public void verifyPhoneNumber(String phoneNumber) throws VerificationFailedException {
    }

    @Override
    public void verifyMailAddress(String mailAddress) throws VerificationFailedException {
        this.verifyNotEmpty(mailAddress, "E-Mail Adress");
    }

    private void verifyNotEmpty(String string, String name) throws VerificationFailedException {
        if (string.isEmpty()) {
            throw new VerificationFailedException(name + " must not be empty!");
        }
    }
}

