/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.permissions;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.JFXTreeTableView;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.util.Callback;
import org.controlsfx.control.textfield.CustomTextField;
import org.openbase.bco.bcozy.permissions.UnitPermissionController;
import org.openbase.bco.bcozy.permissions.model.RecursiveUnitConfig;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.visual.javafx.geometry.svg.SVGGlyphIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class PermissionsPaneController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionsPaneController.class);
    @FXML
    private Parent unitPermission;
    @FXML
    private UnitPermissionController unitPermissionController;
    @FXML
    private CustomTextField filterInput;
    @FXML
    private JFXTreeTableView<RecursiveUnitConfig> unitsTable;
    @FXML
    private JFXTreeTableColumn<RecursiveUnitConfig, String> typeColumn;
    @FXML
    private JFXTreeTableColumn<RecursiveUnitConfig, String> descColumn;
    @FXML
    private JFXTreeTableColumn<RecursiveUnitConfig, String> labelColumn;
    private final ObservableList<RecursiveUnitConfig> list = FXCollections.observableArrayList();

    @FXML
    public void initialize() {
        this.fillTreeTableView();
        try {
            Registries.getUnitRegistry().addDataObserver((observable, unitRegistryData) -> this.fillTable());
            this.fillTable();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void onSelectionChange(Observable observable, TreeItem oldValue, TreeItem newValue) {
        if (Objects.nonNull(newValue) && newValue.getValue() instanceof RecursiveUnitConfig) {
            this.setUnitPermissionVisible(true);
            this.unitPermissionController.setSelectedUnitId(((RecursiveUnitConfig)((Object)newValue.getValue())).getUnit().getId());
        } else {
            this.setUnitPermissionVisible(false);
        }
    }

    private void setUnitPermissionVisible(boolean visible) {
        this.unitPermission.setVisible(visible);
    }

    private void fillTreeTableView() {
        this.labelColumn.setCellValueFactory(new MethodRefCellValueFactory<RecursiveUnitConfig, String>(unit -> unit.getUnit().getLabel(), this.labelColumn));
        this.descColumn.setCellValueFactory(new MethodRefCellValueFactory<RecursiveUnitConfig, String>(unit -> unit.getUnit().getDescription(), this.descColumn));
        this.typeColumn.setCellValueFactory(new MethodRefCellValueFactory<RecursiveUnitConfig, String>(unit -> unit.getUnit().getType().name(), this.typeColumn));
        RecursiveTreeItem item = new RecursiveTreeItem(this.list, RecursiveTreeObject::getChildren);
        this.unitsTable.setRoot((TreeItem)item);
        this.unitsTable.getSelectionModel().selectedItemProperty().addListener(this::onSelectionChange);
        this.filterInput.setRight((Node)new SVGGlyphIcon((GlyphIcons)FontAwesomeIcon.SEARCH, 16.0, true));
        this.filterInput.promptTextProperty().setValue(new ObserverLabel("searchPlaceholder").getText());
        this.filterInput.textProperty().addListener((o, oldVal, newVal) -> this.unitsTable.setPredicate(user -> ((RecursiveUnitConfig)((Object)((Object)((Object)user.getValue())))).getUnit().getLabel().toLowerCase().contains(newVal.toLowerCase()) || ((RecursiveUnitConfig)((Object)((Object)((Object)user.getValue())))).getUnit().getDescription().toLowerCase().contains(newVal.toLowerCase()) || ((RecursiveUnitConfig)((Object)((Object)((Object)user.getValue())))).getUnit().getType().name().toLowerCase().contains(newVal.toLowerCase())));
    }

    private void fillTable() throws CouldNotPerformException, InterruptedException {
        if (Registries.getUnitRegistry().isDataAvailable()) {
            List unitConfigList = Registries.getUnitRegistry().getUnitConfigs();
            Platform.runLater(() -> this.fillTable(unitConfigList));
        }
    }

    private void fillTable(List<UnitConfigType.UnitConfig> unitConfigList) {
        this.unitsTable.unGroup(new TreeTableColumn[]{this.typeColumn});
        this.list.clear();
        for (UnitConfigType.UnitConfig unitConfig : unitConfigList) {
            if (!Objects.nonNull(unitConfig)) continue;
            this.list.add((Object)new RecursiveUnitConfig(unitConfig));
        }
        if (!this.list.isEmpty()) {
            this.unitsTable.group(new TreeTableColumn[]{this.typeColumn});
        }
    }

    private class MethodRefCellValueFactory<S, T>
    implements Callback<TreeTableColumn.CellDataFeatures<S, T>, ObservableValue<T>> {
        Function<S, T> supplier;
        JFXTreeTableColumn<S, T> column;

        public MethodRefCellValueFactory(Function<S, T> supplier, JFXTreeTableColumn<S, T> column) {
            this.supplier = Objects.requireNonNull(supplier);
            this.column = Objects.requireNonNull(column);
        }

        public ObservableValue<T> call(TreeTableColumn.CellDataFeatures<S, T> param) {
            if (this.column.validateValue(param)) {
                return new SimpleObjectProperty(this.supplier.apply(param.getValue().getValue()));
            }
            return this.column.getComputedValue(param);
        }
    }
}

