/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.permissions.model;

import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public abstract class AbstractPermissions {
    private static final Logger LOG = Logger.getLogger(AbstractPermissions.class.getName());
    private final boolean originalRead;
    private final boolean originalWrite;
    private final boolean originalAccess;
    private final StringProperty name = new SimpleStringProperty();
    private final BooleanProperty read = new SimpleBooleanProperty();
    private final BooleanProperty write = new SimpleBooleanProperty();
    private final BooleanProperty access = new SimpleBooleanProperty();

    AbstractPermissions(String name, boolean read, boolean write, boolean access) {
        this.originalAccess = access;
        this.originalRead = read;
        this.originalWrite = write;
        this.name.setValue(name);
        this.read.set(read);
        this.access.set(access);
        this.write.set(write);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public boolean isRead() {
        return this.read.get();
    }

    public BooleanProperty readProperty() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read.set(read);
    }

    public boolean isWrite() {
        return this.write.get();
    }

    public BooleanProperty writeProperty() {
        return this.write;
    }

    public void setWrite(boolean write) {
        this.write.set(write);
    }

    public boolean isAccess() {
        return this.access.get();
    }

    public BooleanProperty accessProperty() {
        return this.access;
    }

    public void setAccess(boolean access) {
        this.access.set(access);
    }

    public boolean changed() {
        return this.changed(this.isRead(), this.isWrite(), this.isAccess());
    }

    protected boolean changed(boolean read, boolean write, boolean access) {
        return read != this.originalRead || access != this.originalAccess || write != this.originalWrite;
    }
}

