/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.openbase.bco.bcozy.util.Language;
import org.openbase.bco.bcozy.util.LanguageLoader;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLanguagesDetector
implements LanguageLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLanguagesDetector.class);

    @Override
    public List<Language> getLanguages() {
        try {
            List<String> lines = this.loadLines();
            List<Locale> locales = this.toLocales(lines);
            ArrayList<Language> languages = new ArrayList<Language>();
            for (Locale locale : locales) {
                languages.add(new Language(locale));
            }
            return languages;
        }
        catch (IOException | URISyntaxException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            return Collections.emptyList();
        }
    }

    private List<String> loadLines() throws URISyntaxException, IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("languages/available_languages");
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            reader.lines().forEach(lines::add);
        }
        return lines;
    }

    private List<Locale> toLocales(List<String> lines) {
        ArrayList<Locale> locales = new ArrayList<Locale>(lines.size());
        for (String line : lines) {
            if (line.contains("_")) {
                locales.add(new Locale(line.split("_")[0], line.split("_")[1]));
                continue;
            }
            locales.add(new Locale(line));
        }
        return locales;
    }
}

