/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeLoader {
    public static final String CSS_SUFFIX = ".css";
    public static final String CSS_FOLDER = "css";
    public static final String THEME_REGISTRY = "css/themes";
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeLoader.class);

    public static List<String> loadThemes() {
        ArrayList<String> lines = new ArrayList<String>();
        InputStream stream = ThemeLoader.class.getClassLoader().getResourceAsStream(THEME_REGISTRY);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            reader.lines().forEach(lines::add);
        }
        catch (IOException ex) {
            ExceptionPrinter.printHistory((String)"Could not load themes!", (Throwable)ex, (Logger)LOGGER);
        }
        return lines;
    }

    public static String getCssUri(String theme) {
        return "css/" + theme.toLowerCase() + CSS_SUFFIX;
    }
}

