/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.StackPane;
import org.openbase.bco.bcozy.controller.CenterPaneController;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.SimpleUnitSymbolsPane;
import org.openbase.bco.bcozy.view.UnitSymbolsPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;

public class BackgroundPane
extends StackPane {
    private final LocationPane locationPane;
    private final UnitSymbolsPane unitSymbolsPane;
    private final SimpleUnitSymbolsPane editingLayerPane;
    private final SimpleUnitSymbolsPane maintenanceLayerPane;
    private double prevMouseCordX;
    private double prevMouseCordY;

    public BackgroundPane(ForegroundPane foregroundPane) throws InstantiationException, InterruptedException {
        try {
            this.locationPane = new LocationPane(foregroundPane);
            this.getChildren().add((Object)this.locationPane);
            this.unitSymbolsPane = new UnitSymbolsPane();
            this.unitSymbolsPane.setPickOnBounds(false);
            this.getChildren().add((Object)this.unitSymbolsPane);
            this.unitSymbolsPane.selectedLocationId.bind((ObservableValue)this.locationPane.selectedLocationId);
            this.maintenanceLayerPane = new SimpleUnitSymbolsPane();
            this.maintenanceLayerPane.setPickOnBounds(false);
            this.editingLayerPane = new SimpleUnitSymbolsPane();
            this.editingLayerPane.setPickOnBounds(false);
            foregroundPane.getAppState().addListener((ChangeListener)new ChangeListener<CenterPaneController.State>(){

                public void changed(ObservableValue<? extends CenterPaneController.State> observable, CenterPaneController.State oldValue, CenterPaneController.State newValue) {
                    switch (newValue) {
                        case SETTINGS: {
                            BackgroundPane.this.getChildren().clear();
                            BackgroundPane.this.getChildren().add((Object)BackgroundPane.this.locationPane);
                            BackgroundPane.this.getChildren().add((Object)BackgroundPane.this.editingLayerPane);
                            break;
                        }
                        case TEMPERATURE: {
                            BackgroundPane.this.getChildren().clear();
                            BackgroundPane.this.getChildren().add((Object)BackgroundPane.this.locationPane);
                            BackgroundPane.this.getChildren().add((Object)BackgroundPane.this.maintenanceLayerPane);
                            break;
                        }
                        case MOVEMENT: {
                            BackgroundPane.this.getChildren().clear();
                            BackgroundPane.this.getChildren().add((Object)BackgroundPane.this.locationPane);
                            BackgroundPane.this.getChildren().add((Object)BackgroundPane.this.unitSymbolsPane);
                        }
                    }
                }
            });
            this.getStyleClass().add((Object)"background-pane");
            this.setOnMousePressed(event -> {
                this.prevMouseCordX = event.getX();
                this.prevMouseCordY = event.getY();
            });
            this.setOnMouseDragged(event -> {
                this.locationPane.setTranslateX(this.locationPane.getTranslateX() + (event.getX() - this.prevMouseCordX));
                this.locationPane.setTranslateY(this.locationPane.getTranslateY() + (event.getY() - this.prevMouseCordY));
                this.prevMouseCordX = event.getX();
                this.prevMouseCordY = event.getY();
            });
            this.setOnScroll(event -> {
                event.consume();
                if (event.getDeltaY() == 0.0) {
                    return;
                }
                double scaleFactor = event.getDeltaY() > 0.0 ? 1.05 : 0.9523809523809523;
                this.locationPane.setScaleX(this.locationPane.getScaleX() * scaleFactor);
                this.locationPane.setScaleY(this.locationPane.getScaleY() * scaleFactor);
                this.locationPane.setTranslateX(this.locationPane.getTranslateX() * scaleFactor);
                this.locationPane.setTranslateY(this.locationPane.getTranslateY() * scaleFactor);
            });
            this.setOnMouseClicked(this.locationPane.getOnEmptyAreaClickHandler());
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public UnitSymbolsPane getUnitsPane() {
        return this.unitSymbolsPane;
    }

    public SimpleUnitSymbolsPane getMaintenancePane() {
        return this.maintenanceLayerPane;
    }

    public SimpleUnitSymbolsPane getEditingPane() {
        return this.editingLayerPane;
    }

    public LocationPane getLocationPane() {
        return this.locationPane;
    }
}

