/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.openbase.bco.authentication.lib.jp.JPAuthentication;
import org.openbase.bco.bcozy.view.FloatingButton;
import org.openbase.bco.bcozy.view.mainmenupanes.AvailableUsersPane;
import org.openbase.bco.bcozy.view.mainmenupanes.LoginPane;
import org.openbase.bco.bcozy.view.mainmenupanes.LogoPane;
import org.openbase.bco.bcozy.view.mainmenupanes.ObserverTitledPane;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.visual.javafx.geometry.svg.SVGGlyphIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainMenu
extends StackPane
implements VoidInitializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainMenu.class);
    private final LoginPane loginPane;
    private final FloatingButton mainMenuFloatingButton;
    private final VBox verticalLayout;
    private final VBox verticalLayoutSmall;
    private final double height;
    private final double width;
    private final AvailableUsersPane availableUsersPane;
    private final LogoPane logoPane;
    private boolean maximized;
    private TitledPane loginContainer;

    public MainMenu(double height, double width) throws InstantiationException {
        try {
            this.height = height;
            this.width = width;
            this.maximized = true;
            this.setMinHeight(height);
            this.setMinWidth(width);
            this.setPrefWidth(width);
            this.verticalLayout = new VBox(10.0);
            this.verticalLayout.setAlignment(Pos.TOP_CENTER);
            this.verticalLayoutSmall = new VBox(20.0);
            this.verticalLayoutSmall.setAlignment(Pos.TOP_CENTER);
            this.logoPane = new LogoPane();
            this.loginPane = new LoginPane();
            this.availableUsersPane = new AvailableUsersPane();
            this.mainMenuFloatingButton = new FloatingButton(new SVGGlyphIcon(MaterialIcon.MENU, 42.0, true));
            this.loginContainer = new ObserverTitledPane("login");
            this.loginContainer.getStyleClass().addAll((Object[])new String[]{"login-titled-pane"});
            this.loginContainer.setGraphic((Node)new SVGGlyphIcon(MaterialDesignIcon.LOGIN, 16.0, true));
            this.loginContainer.setContent((Node)this.loginPane);
            StackPane.setAlignment((Node)this.mainMenuFloatingButton, (Pos)Pos.TOP_RIGHT);
            StackPane.setAlignment((Node)this.verticalLayout, (Pos)Pos.TOP_CENTER);
            StackPane.setAlignment((Node)this.verticalLayoutSmall, (Pos)Pos.TOP_CENTER);
            this.mainMenuFloatingButton.translateYProperty().set(-55.0);
            try {
                if (((Boolean)((JPAuthentication)JPService.getProperty(JPAuthentication.class)).getValue()).booleanValue()) {
                    this.verticalLayout.getChildren().addAll((Object[])new Node[]{this.logoPane, this.loginContainer, this.availableUsersPane});
                } else {
                    this.verticalLayout.getChildren().addAll((Object[])new Node[]{this.logoPane, this.availableUsersPane});
                }
            }
            catch (JPNotAvailableException e) {
                this.verticalLayout.getChildren().addAll((Object[])new Node[]{this.logoPane, this.availableUsersPane});
            }
            this.getChildren().addAll((Object[])new Node[]{this.verticalLayout, this.mainMenuFloatingButton});
            this.getStyleClass().addAll((Object[])new String[]{"main-menu"});
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            this.availableUsersPane.init();
        }
        catch (CouldNotPerformException ex) {
            new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public FloatingButton getMainMenuFloatingButton() {
        return this.mainMenuFloatingButton;
    }

    public LoginPane getLoginPane() {
        return this.loginPane;
    }

    public AvailableUsersPane getAvailableUsersPanePane() {
        return this.availableUsersPane;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void maximizeMainMenu() {
        this.maximized = true;
        this.setMinHeight(this.height);
        this.setMinWidth(this.width);
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.getChildren().clear();
        StackPane.setAlignment((Node)this.mainMenuFloatingButton, (Pos)Pos.TOP_RIGHT);
        this.mainMenuFloatingButton.translateYProperty().set(-55.0);
        this.getChildren().addAll((Object[])new Node[]{this.verticalLayout, this.mainMenuFloatingButton});
    }

    public void minimizeMainMenu() {
        this.maximized = false;
        this.setMinHeight(this.height);
        this.setPrefHeight(this.height);
        this.setMinWidth(60.0);
        this.setPrefWidth(98.0);
        StackPane.setAlignment((Node)this.mainMenuFloatingButton, (Pos)Pos.TOP_CENTER);
        this.mainMenuFloatingButton.translateYProperty().set(-55.0);
        this.verticalLayoutSmall.getChildren().clear();
        this.verticalLayoutSmall.getChildren().addAll((Object[])new Node[]{this.logoPane.getStatusIcon(), this.loginPane.getStatusIcon(), this.availableUsersPane.getStatusIcon()});
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{this.verticalLayoutSmall, this.mainMenuFloatingButton});
    }
}

