/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import java.util.Observable;
import java.util.Observer;
import java.util.function.Function;
import javafx.beans.DefaultProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.openbase.bco.bcozy.model.LanguageSelection;

@DefaultProperty(value="identifier")
public class ObserverLabel
extends Label
implements Observer {
    @FXML
    private SimpleStringProperty identifier = new SimpleStringProperty();
    private Function<String, String> applyOnNewText = Function.identity();

    public ObserverLabel() {
        this.identifier.addListener((observable, oldValue, newValue) -> this.update(null, null));
        LanguageSelection.getInstance().addObserver(this);
    }

    public ObserverLabel(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public ObserverLabel(String identifier, Node graphic) {
        this(identifier);
        super.setGraphic(graphic);
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (this.getIdentifier() == null || this.getIdentifier().equals("DUMMY")) {
            return;
        }
        if (this.getIdentifier().isEmpty()) {
            super.setText("");
        }
        super.setText(this.applyOnNewText.apply(LanguageSelection.getLocalized(this.getIdentifier())));
    }

    public void setIdentifier(String identifier) {
        this.identifier.set(identifier);
    }

    public String getIdentifier() {
        return this.identifier.get();
    }

    public SimpleStringProperty identifierProperty() {
        return this.identifier;
    }

    public void setApplyOnNewText(Function<String, String> applyOnNewText) {
        this.applyOnNewText = applyOnNewText != null ? applyOnNewText : Function.identity();
        this.update(null, null);
    }
}

