/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import com.google.protobuf.GeneratedMessage;
import javafx.scene.layout.Pane;
import org.openbase.bco.bcozy.view.generic.WidgetPane;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.bcozy.view.pane.unit.UnitPaneFactoryImpl;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class UnitButton
extends Pane {
    protected final Logger LOGGER = LoggerFactory.getLogger(UnitButton.class);
    private UnitRemote<? extends GeneratedMessage> unitRemote;

    public UnitButton(UnitRemote<? extends GeneratedMessage> unitRemote) throws InterruptedException, CouldNotPerformException {
        AbstractUnitPane content = UnitPaneFactoryImpl.getInstance().newInitializedInstance((UnitConfigType.UnitConfig)unitRemote.getConfig());
        content.setDisplayMode(WidgetPane.DisplayMode.ICON_ONLY);
        this.unitRemote = content.getUnitRemote();
        this.getChildren().add((Object)content);
        this.getStyleClass().clear();
        this.getStyleClass().addAll((Object[])new String[]{"units-button"});
    }

    public UnitRemote<? extends GeneratedMessage> getUnitRemote() {
        return this.unitRemote;
    }

    public String getLocationId() throws CouldNotPerformException {
        try {
            return ((UnitConfigType.UnitConfig)this.unitRemote.getConfig()).getPlacementConfig().getLocationId();
        }
        catch (NotAvailableException ex) {
            throw new CouldNotPerformException("Could not retrieve locationId for unit", (Throwable)ex);
        }
    }
}

