/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import java.util.concurrent.TimeUnit;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Pair;
import org.openbase.bco.bcozy.util.ThemeManager;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.bco.registry.unit.remote.UnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.Remote;
import org.openbase.jul.schedule.GlobalScheduledExecutorService;
import org.openbase.jul.visual.javafx.fxml.FXMLProcessor;
import org.openbase.jul.visual.javafx.geometry.svg.SVGIcon;
import org.openbase.jul.visual.javafx.geometry.svg.SVGLogoPaneController;
import org.openbase.jul.visual.javafx.geometry.svg.SVGPathIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoPane
extends HBox {
    public static final double LOGO_SIZE = 80.0;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoPane.class);
    private final VBox statusIcon;
    private final SVGLogoPaneController logoPaneController;
    private final SVGPathIcon smallLogoIcon;

    public LogoPane() throws InstantiationException {
        try {
            Pair logoPanePair = FXMLProcessor.loadFxmlPaneAndControllerPair((String)"/org/openbase/jul/visual/javafx/geometry/svg/SVGLogoPane.fxml", SVGLogoPaneController.class, ((Object)((Object)this)).getClass());
            this.logoPaneController = (SVGLogoPaneController)logoPanePair.getValue();
            this.smallLogoIcon = new SVGPathIcon("icons/bco_logo_simple_background_one_path.svg", "icons/bco_logo_simple_one_path.svg", ((Object)((Object)this)).getClass(), 42.0);
            this.logoPaneController.setText("BCozy");
            this.logoPaneController.setSvgIcon((SVGIcon)new SVGPathIcon("icons/bco_logo_simple_background_one_path.svg", "icons/bco_logo_simple_one_path.svg", ((Object)((Object)this)).getClass(), 80.0));
            this.logoPaneController.setSize(80.0);
            this.logoPaneController.getSVGIcon().setBackgroundIconColor(Color.WHITE);
            this.smallLogoIcon.setBackgroundIconColor(Color.WHITE);
            this.logoPaneController.getTextPane().getStyleClass().add((Object)"icons");
            try {
                UnitRegistryRemote unitRegistry = Registries.getUnitRegistry((boolean)false);
                unitRegistry.addConnectionStateObserver((source, connectionState) -> this.updateIconState((Remote.ConnectionState)connectionState));
                this.updateIconState(unitRegistry.getConnectionState());
                this.smallLogoIcon.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
                    this.updateIconState();
                    unitRegistry.ping();
                });
                this.logoPaneController.getSVGIcon().addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
                    this.updateIconState();
                    unitRegistry.ping();
                });
                GlobalScheduledExecutorService.scheduleAtFixedRate(() -> unitRegistry.ping(), (long)30L, (long)60L, (TimeUnit)TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.statusIcon = new VBox(new Node[]{this.smallLogoIcon});
            this.statusIcon.setAlignment(Pos.CENTER);
            this.statusIcon.setSpacing(20.0);
            this.setAlignment(Pos.CENTER);
            this.getChildren().addAll((Object[])new Node[]{(Node)logoPanePair.getKey()});
            this.setSpacing(20.0);
            ThemeManager.getInstance().themeName.addListener((observable, oldValue, newValue) -> this.updateIconState(false));
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    private void updateIconState() {
        this.updateIconState(true);
    }

    private void updateIconState(boolean animation) {
        try {
            this.updateIconState(Registries.getUnitRegistry().getConnectionState(), animation);
        }
        catch (NotAvailableException ex) {
            ExceptionPrinter.printHistory((String)"Could not update icon state!", (Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void updateIconState(Remote.ConnectionState connectionState) {
        this.updateIconState(connectionState, true);
    }

    private void updateIconState(Remote.ConnectionState connectionState, boolean animation) {
        Color inversDefaultColor;
        Color defaultColor;
        if (ThemeManager.isDarkThemeSelected()) {
            defaultColor = Color.WHITE;
            inversDefaultColor = Color.BLACK;
        } else {
            defaultColor = Color.BLACK;
            inversDefaultColor = Color.WHITE;
        }
        this.logoPaneController.getSVGIcon().setForegroundIconColor(defaultColor);
        this.smallLogoIcon.setForegroundIconColor(defaultColor);
        switch (connectionState) {
            case CONNECTED: {
                this.logoPaneController.getSVGIcon().setBackgroundIconColor(inversDefaultColor);
                this.smallLogoIcon.setBackgroundIconColor(inversDefaultColor);
                if (!animation) break;
                this.logoPaneController.getSVGIcon().setBackgroundIconColorAnimated(Color.GREEN, 20);
                this.smallLogoIcon.setBackgroundIconColorAnimated(Color.GREEN, 20);
                break;
            }
            case CONNECTING: 
            case REINITIALIZING: 
            case RECONNECTING: {
                this.logoPaneController.getSVGIcon().setBackgroundIconColor(Color.ORANGE);
                this.smallLogoIcon.setBackgroundIconColor(Color.ORANGE);
                if (!animation) break;
                this.logoPaneController.getSVGIcon().setBackgroundIconColorAnimated(inversDefaultColor, 20);
                this.smallLogoIcon.setBackgroundIconColorAnimated(inversDefaultColor, 20);
                break;
            }
            default: {
                this.logoPaneController.getSVGIcon().setBackgroundIconColor(Color.RED);
                this.smallLogoIcon.setBackgroundIconColor(Color.RED);
                if (!animation) break;
                this.logoPaneController.getSVGIcon().setBackgroundIconColorAnimated(inversDefaultColor, 20);
                this.smallLogoIcon.setBackgroundIconColorAnimated(inversDefaultColor, 20);
            }
        }
    }

    public Node getStatusIcon() {
        return this.statusIcon;
    }
}

